/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.prefs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.base.util.PasswordObscurification;

public abstract class PreferencesMap<T extends ConfigurationData> {
    private static final String VERSION_KEY = "#version";
    private static final String URL_KEY = "#url";
    private LinkedHashMap<String, DataHolder<T>> backend;
    private LinkedHashMap<String, DataHolder<T>> removedNodes;
    private Preferences storageBackend;

    public PreferencesMap(Preferences preferences) {
        if (preferences == null) {
            throw new NullPointerException();
        }
        this.storageBackend = preferences;
        this.backend = new LinkedHashMap();
        this.removedNodes = new LinkedHashMap();
    }

    protected abstract T create(String var1, long var2);

    protected T get(String key) {
        DataHolder<T> holder = this.backend.get(key);
        if (holder != null) {
            return holder.getConfigurationData();
        }
        return null;
    }

    protected void init() {
        try {
            this.sync();
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    protected String[] getKnownKeys() {
        return this.backend.keySet().toArray(new String[this.backend.size()]);
    }

    protected void add(T configurationData) {
        DataHolder data = new DataHolder((ConfigurationData)configurationData, null);
        DataHolder oldData = this.backend.put(data.getKey(), data);
        if (oldData != null) {
            data.setNodeName(oldData.getNodeName());
        }
        try {
            this.sync();
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    protected void remove(String key) {
        DataHolder data = (DataHolder)this.backend.remove(key);
        if (data != null) {
            this.removedNodes.put(key, data);
            try {
                this.sync();
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    public void sync() throws BackingStoreException {
        Iterator<DataHolder<T>> removedNodes = this.removedNodes.values().iterator();
        while (removedNodes.hasNext()) {
            DataHolder<T> s = removedNodes.next();
            removedNodes.remove();
            String nodeName = s.getNodeName();
            if (nodeName == null) continue;
            this.storageBackend.node(nodeName);
        }
        LinkedHashMap dataFromStore = new LinkedHashMap();
        Object[] strings = this.storageBackend.childrenNames();
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            Object name = strings[i];
            if (!((String)name).startsWith("#")) continue;
            Preferences authNode = this.storageBackend.node((String)name);
            String url = authNode.get(URL_KEY, null);
            if (url == null) {
                authNode.removeNode();
                continue;
            }
            long authTime = authNode.getLong(VERSION_KEY, 0L);
            DataHolder data = new DataHolder((ConfigurationData)this.create(url, authTime), null);
            String[] options = authNode.keys();
            for (int j = 0; j < options.length; ++j) {
                String option = options[j];
                if (option.startsWith("#")) continue;
                data.getConfigurationData().setOption(option, PasswordObscurification.decryptPasswordWithOptionalEncoding((String)authNode.get(option, null)));
            }
            data.setNodeName((String)name);
            data.setLastChanged(authTime);
            dataFromStore.put(url, data);
        }
        ArrayList<DataHolder<T>> dataToWrite = new ArrayList<DataHolder<T>>();
        ArrayList<DataHolder<T>> datas = new ArrayList<DataHolder<T>>(this.backend.values());
        for (DataHolder<T> local : datas) {
            String url = local.getKey();
            DataHolder fromStore = (DataHolder)dataFromStore.get(url);
            if (fromStore == null) {
                dataToWrite.add(local);
                continue;
            }
            if (local.getLastChanged() > fromStore.getLastChanged()) {
                dataToWrite.add(local);
                dataFromStore.remove(url);
                continue;
            }
            if (local.getLastChanged() < fromStore.getLastChanged()) {
                this.backend.put(url, fromStore);
                dataFromStore.remove(url);
                continue;
            }
            dataFromStore.remove(url);
        }
        this.backend.putAll(dataFromStore);
        HashSet<Object> names = new HashSet<Object>(Arrays.asList(strings));
        for (int i = 0; i < dataToWrite.size(); ++i) {
            DataHolder data = (DataHolder)dataToWrite.get(i);
            String existingName = data.getNodeName();
            String name = null;
            if (existingName != null) {
                Preferences preferences = this.storageBackend.node(existingName);
                String key = preferences.get(URL_KEY, null);
                if (data.getKey().equals(key)) {
                    name = existingName;
                }
            }
            if (name == null) {
                name = this.generateName(names);
            }
            if (name == null) continue;
            Preferences subnode = this.storageBackend.node(name);
            data.setNodeName(name);
            subnode.putLong(VERSION_KEY, data.getLastChanged());
            subnode.put(URL_KEY, data.getKey());
            String[] optionKeys = data.getConfigurationData().getDefinedOptions();
            for (int j = 0; j < optionKeys.length; ++j) {
                String password;
                String optionKey = optionKeys[j];
                if (optionKey.startsWith("#") || (password = data.getConfigurationData().getOption(optionKey)) == null) continue;
                subnode.put(optionKey, PasswordObscurification.encryptPasswordWithOptionalEncoding((String)password));
            }
        }
    }

    private String generateName(HashSet names) throws BackingStoreException {
        String nodeName;
        int i;
        for (i = 0; i < names.size(); ++i) {
            nodeName = "#" + i;
            if (names.contains(nodeName)) continue;
            return nodeName;
        }
        for (i = 0; i < 9999; ++i) {
            nodeName = "#" + i;
            if (this.storageBackend.nodeExists(nodeName)) continue;
            return nodeName;
        }
        return null;
    }

    public String getMostRecentEntry() {
        long age = 0L;
        String result = null;
        for (Map.Entry<String, DataHolder<T>> entry : this.backend.entrySet()) {
            DataHolder<T> holder = entry.getValue();
            if (holder.getLastChanged() <= age) continue;
            age = holder.getLastChanged();
            result = entry.getKey();
        }
        return result;
    }

    static class 1 {
    }

    private static class DataHolder<T extends ConfigurationData> {
        private T configurationData;
        private String nodeName;

        private DataHolder(T configurationData) {
            this.configurationData = configurationData;
        }

        public T getConfigurationData() {
            return this.configurationData;
        }

        public String getKey() {
            return this.configurationData.getKey();
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public long getLastChanged() {
            return this.configurationData.getLastChanged();
        }

        public void setLastChanged(long time) {
            this.configurationData.setLastChanged(time);
        }

        /* synthetic */ DataHolder(ConfigurationData x0, 1 x1) {
            this(x0);
        }
    }

    public static interface ConfigurationData {
        public String getKey();

        public String getOption(String var1);

        public void setOption(String var1, String var2);

        public String[] getDefinedOptions();

        public long getLastChanged();

        public void setLastChanged(long var1);
    }
}

