/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.table.ArrayTableModel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkDownAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkUpAction;

public class FormatEditorDialog
extends CommonDialog {
    private ArrayTableModel dateFormatModel;
    private ArrayTableModel numberFormatModel;
    private ElementMetaDataTable dateFormatTable;
    private ElementMetaDataTable numberFormatTable;

    public FormatEditorDialog() {
        this.init();
    }

    public FormatEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public FormatEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(SettingsMessages.getInstance().getString("FormatEditorDialog.Title"));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.FormatEditor";
    }

    protected Component createContentPane() {
        this.dateFormatModel = new ArrayTableModel();
        this.dateFormatModel.setColumnTitle(SettingsMessages.getInstance().getString("FormatEditorDialog.DateFormat"));
        this.numberFormatModel = new ArrayTableModel();
        this.numberFormatModel.setColumnTitle(SettingsMessages.getInstance().getString("FormatEditorDialog.NumberFormat"));
        this.dateFormatTable = new ElementMetaDataTable();
        this.dateFormatTable.setModel(this.dateFormatModel);
        this.numberFormatTable = new ElementMetaDataTable();
        this.numberFormatTable.setModel(this.numberFormatModel);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.createTablePanel(this.numberFormatTable, this.numberFormatModel));
        panel.add(this.createTablePanel(this.dateFormatTable, this.dateFormatModel));
        return panel;
    }

    private JPanel createTablePanel(ElementMetaDataTable dateFormatTable, ArrayTableModel dateFormatModel) {
        ListSelectionModel selectionModel = dateFormatTable.getSelectionModel();
        AddEntryAction addGroupAction = new AddEntryAction(dateFormatModel);
        RemoveEntryAction removeGroupAction = new RemoveEntryAction(dateFormatModel, selectionModel, dateFormatTable);
        SortBulkUpAction sortUpAction = new SortBulkUpAction((BulkDataProvider)dateFormatModel, selectionModel, (JTable)dateFormatTable);
        SortBulkDownAction sortDownAction = new SortBulkDownAction((BulkDataProvider)dateFormatModel, selectionModel, (JTable)dateFormatTable);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add((Component)new BorderlessButton((Action)sortUpAction));
        buttonsPanel.add((Component)new BorderlessButton((Action)sortDownAction));
        buttonsPanel.add(Box.createHorizontalStrut(20));
        buttonsPanel.add((Component)new BorderlessButton((Action)addGroupAction));
        buttonsPanel.add((Component)new BorderlessButton((Action)removeGroupAction));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(dateFormatTable), "Center");
        panel.add((Component)buttonsPanel, "North");
        return panel;
    }

    public Result editArray(String[] dateFormats, String[] numberFormats) {
        this.numberFormatModel.setType(String.class);
        this.numberFormatModel.setValueRole("NumberFormat");
        this.numberFormatModel.setData(numberFormats, String.class);
        this.dateFormatModel.setType(String.class);
        this.dateFormatModel.setValueRole("NumberFormat");
        this.dateFormatModel.setData(dateFormats, String.class);
        if (!this.performEdit()) {
            return null;
        }
        if (this.dateFormatTable.getCellEditor() != null) {
            this.dateFormatTable.getCellEditor().stopCellEditing();
        }
        if (this.numberFormatTable.getCellEditor() != null) {
            this.numberFormatTable.getCellEditor().stopCellEditing();
        }
        String[] dateFormatString = new String[this.dateFormatModel.getSize()];
        for (int i = 0; i < this.dateFormatModel.getSize(); ++i) {
            dateFormatString[i] = String.valueOf(this.dateFormatModel.get(i));
        }
        String[] numberFormatString = new String[this.numberFormatModel.getSize()];
        for (int i = 0; i < this.numberFormatModel.getSize(); ++i) {
            numberFormatString[i] = String.valueOf(this.numberFormatModel.get(i));
        }
        return new Result(dateFormatString, numberFormatString);
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.dateFormatTable.getReportDesignerContext();
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        if (reportDesignerContext != null) {
            this.dateFormatTable.setReportDesignerContext(reportDesignerContext);
            this.numberFormatTable.setReportDesignerContext(reportDesignerContext);
        } else {
            this.dateFormatTable.setReportDesignerContext(null);
            this.numberFormatTable.setReportDesignerContext(null);
        }
    }

    public static class Result {
        private String[] dateFormats;
        private String[] numberFormats;

        public Result(String[] dateFormats, String[] numberFormats) {
            this.dateFormats = dateFormats;
            this.numberFormats = numberFormats;
        }

        public String[] getDateFormats() {
            return this.dateFormats;
        }

        public String[] getNumberFormats() {
            return this.numberFormats;
        }
    }

    private class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private ArrayTableModel tableModel;
        private JTable table;

        private RemoveEntryAction(ArrayTableModel tableModel, ListSelectionModel selectionModel, JTable table) {
            this.tableModel = tableModel;
            this.table = table;
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", SettingsMessages.getInstance().getString("FormatEditorDialog.RemoveEntry.Description"));
            this.selectionModel = selectionModel;
            this.selectionModel.addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            this.stopCellEditing();
            int maxIdx = this.selectionModel.getMaxSelectionIndex();
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = this.selectionModel.getMinSelectionIndex(); i <= maxIdx; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                list.add(0, i);
            }
            for (i = 0; i < list.size(); ++i) {
                Integer dataEntry = (Integer)list.get(i);
                this.tableModel.remove(dataEntry);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        protected void stopCellEditing() {
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
        }
    }

    private static class AddEntryAction
    extends AbstractAction {
        private ArrayTableModel tableModel;

        private AddEntryAction(ArrayTableModel tableModel) {
            this.tableModel = tableModel;
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", SettingsMessages.getInstance().getString("FormatEditorDialog.AddEntry.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tableModel.add(null);
        }
    }
}

