/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.status;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.status.ExceptionsListModel;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ExceptionDialog
extends JDialog {
    private ExceptionsListModel dataModel;
    private JTextArea stacktraceTextArea;
    private JList list;

    public ExceptionDialog() {
        this.init();
    }

    public ExceptionDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public ExceptionDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setTitle(Messages.getString("ExceptionDialog.Title", new Object[0]));
        this.setDefaultCloseOperation(2);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.dataModel = new ExceptionsListModel();
        this.list = new JList(this.dataModel);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setVisibleRowCount(10);
        this.stacktraceTextArea = new JTextArea();
        this.stacktraceTextArea.setEditable(false);
        this.stacktraceTextArea.setColumns(60);
        this.stacktraceTextArea.setRows(10);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(new JButton(new CloseAction()));
        buttonPanel.add(new JButton(new ClearAction()));
        buttonPanel.add(new JButton(new CopyAction()));
        JPanel buttonCarrier = new JPanel(new FlowLayout(2));
        buttonCarrier.add(buttonPanel);
        contentPane.add((Component)buttonCarrier, "South");
        this.list.addListSelectionListener(new ExceptionSelectionListener());
        if (this.dataModel.getSize() > 0) {
            this.list.setSelectedIndex(this.dataModel.getSize() - 1);
        }
        JSplitPane splitPane = new JSplitPane(0, true, new JScrollPane(this.list), new JScrollPane(this.stacktraceTextArea));
        splitPane.setDividerLocation(150);
        contentPane.add((Component)splitPane, "Center");
        this.setContentPane(contentPane);
        this.pack();
        LibSwingUtil.centerFrameOnScreen((Window)this);
        InputMap inputMap = contentPane.getInputMap();
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("cancel", new CloseAction());
    }

    protected ExceptionsListModel getDataModel() {
        return this.dataModel;
    }

    protected Throwable getSelectedThrowable() {
        return (Throwable)this.list.getSelectedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStacktraceText(Throwable throwableInfo) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            throwableInfo.printStackTrace(pw);
            String string = sw.getBuffer().toString();
            return string;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    protected void setStracktraceText(Throwable t) {
        if (t == null) {
            this.stacktraceTextArea.setText("");
        } else {
            String text = ExceptionDialog.getStacktraceText(t);
            this.stacktraceTextArea.setText(text);
            this.stacktraceTextArea.setCaretPosition(0);
        }
    }

    public void showDialog() {
        this.dataModel.refresh();
        this.setVisible(true);
    }

    public static void showDialog(Component parent) {
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ExceptionDialog exceptionDialog = window instanceof Dialog ? new ExceptionDialog((Dialog)window) : (window instanceof Frame ? new ExceptionDialog((Frame)window) : new ExceptionDialog());
        exceptionDialog.showDialog();
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
            this.putValue("Name", Messages.getString("ExceptionDialog.Close", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExceptionDialog.this.dispose();
        }
    }

    private class ExceptionSelectionListener
    implements ListSelectionListener {
        private ExceptionSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Throwable selectedValue = ExceptionDialog.this.getSelectedThrowable();
                ExceptionDialog.this.setStracktraceText(selectedValue);
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        private ClearAction() {
            this.putValue("Name", Messages.getString("ExceptionDialog.Clear", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UncaughtExceptionsModel.getInstance().clearExceptions();
            ExceptionsListModel dataModel = ExceptionDialog.this.getDataModel();
            dataModel.refresh();
            ExceptionDialog.this.setStracktraceText(null);
        }
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
            this.putValue("Name", Messages.getString("ExceptionDialog.CopyToClipboard", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringWriter b = new StringWriter();
            PrintWriter pw = new PrintWriter(b);
            ExceptionsListModel dataModel = ExceptionDialog.this.getDataModel();
            int size = dataModel.getSize();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    pw.println();
                    pw.println();
                }
                Throwable at = (Throwable)dataModel.getElementAt(i);
                at.printStackTrace(pw);
            }
            pw.close();
            ClipboardManager.getManager().setRawContent(new StringSelection(b.toString()));
        }
    }
}

