/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class ActionToggleButton
extends JToggleButton {
    private SelectedHandler selectedHandler;
    private KeyStroke accelerator;

    public ActionToggleButton() {
    }

    public ActionToggleButton(Action a) {
        super(a);
    }

    @Override
    public void setAction(Action a) {
        Action oldAction;
        if (this.selectedHandler == null) {
            this.selectedHandler = new SelectedHandler();
        }
        if ((oldAction = this.getAction()) != null) {
            oldAction.removePropertyChangeListener(this.selectedHandler);
        }
        super.setAction(a);
        KeyStroke ks = a == null ? null : (KeyStroke)a.getValue("AcceleratorKey");
        this.setAccelerator(ks);
        if (a != null) {
            a.addPropertyChangeListener(this.selectedHandler);
        }
    }

    public void setAccelerator(KeyStroke ks) {
        this.unregisterKeyboardAction(this.accelerator);
        if (this.getAction() != null && ks != null) {
            this.registerKeyboardAction(this.getAction(), ks, 2);
        }
        this.accelerator = ks;
    }

    private class SelectedHandler
    implements PropertyChangeListener {
        private SelectedHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selected".equals(evt.getPropertyName())) {
                ActionToggleButton.this.setSelected(Boolean.TRUE.equals(evt.getNewValue()));
            }
            if ("AcceleratorKey".equals(evt.getPropertyName())) {
                KeyStroke ks = (KeyStroke)evt.getNewValue();
                ActionToggleButton.this.setAccelerator(ks);
            }
        }
    }
}

