/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorDialog;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionUtil;
import org.pentaho.reporting.designer.core.util.ExpressionComboBoxEditor;
import org.pentaho.reporting.designer.core.util.ExpressionListCellRenderer;
import org.pentaho.reporting.designer.core.util.GUIUtils;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.CellEditorUtility;
import org.pentaho.reporting.designer.core.util.table.expressions.ExpressionPropertiesDialog;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ExpressionEditorPane
extends JPanel {
    private static final String POPUP_EDITOR = "popupEditor";
    private JComboBox expressionEditor;
    private ReportDesignerContext reportDesignerContext;
    private static final FieldDefinition[] EMPTY_FIELDS = new FieldDefinition[0];

    public ExpressionEditorPane() {
        JButton ellipsisButton = new JButton("...");
        ellipsisButton.setDefaultCapable(false);
        ellipsisButton.setMargin(new Insets(0, 0, 0, 0));
        ellipsisButton.addActionListener(new ExtendedEditorAction());
        DefaultComboBoxModel<ExpressionMetaData> model = new DefaultComboBoxModel<ExpressionMetaData>(ExpressionUtil.getInstance().getKnownExpressions());
        model.insertElementAt(null, 0);
        this.expressionEditor = new JComboBox<ExpressionMetaData>(model);
        this.expressionEditor.setEditable(true);
        this.expressionEditor.setRenderer(new ExpressionListCellRenderer());
        this.expressionEditor.setEditor(new ExpressionComboBoxEditor(true));
        this.expressionEditor.getInputMap().put(UtilMessages.getInstance().getOptionalKeyStroke("AbstractStringValueCellEditor.Popup.Accelerator"), POPUP_EDITOR);
        this.expressionEditor.getActionMap().put(POPUP_EDITOR, new ExtendedEditorAction());
        this.setLayout(new BorderLayout());
        this.add((Component)this.expressionEditor, "Center");
        this.add((Component)ellipsisButton, "East");
    }

    protected JComboBox getExpressionEditor() {
        return this.expressionEditor;
    }

    public ReportDocumentContext getRenderContext() {
        if (this.reportDesignerContext == null) {
            return null;
        }
        ReportDocumentContext activeContext = this.reportDesignerContext.getActiveContext();
        if (activeContext instanceof ReportDocumentContext) {
            return activeContext;
        }
        return null;
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    public FieldDefinition[] getFields() {
        return CellEditorUtility.getFields(this.getRenderContext(), new String[0]);
    }

    public void setValue(Expression expression) {
        this.expressionEditor.setSelectedItem(expression);
    }

    public Expression getValue() {
        Object o = this.expressionEditor.getSelectedItem();
        if (o instanceof ExpressionMetaData) {
            try {
                ExpressionMetaData emd = (ExpressionMetaData)o;
                return (Expression)emd.getExpressionType().newInstance();
            }
            catch (Throwable t) {
                UncaughtExceptionsModel.getInstance().addException(t);
                return null;
            }
        }
        if (o instanceof Expression) {
            return (Expression)o;
        }
        return null;
    }

    private class ExtendedEditorAction
    extends AbstractAction {
        private ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window w = LibSwingUtil.getWindowAncestor((Component)ExpressionEditorPane.this);
            JComboBox expressionEditor = ExpressionEditorPane.this.getExpressionEditor();
            Object selectedItem = expressionEditor.getSelectedItem();
            if (selectedItem instanceof FormulaExpression) {
                FormulaExpression fe = (FormulaExpression)selectedItem;
                FormulaEditorDialog dialog = GUIUtils.createFormulaEditorDialog(ExpressionEditorPane.this.getReportDesignerContext(), ExpressionEditorPane.this);
                String formula = dialog.editFormula(fe.getFormula(), ExpressionEditorPane.this.getFields());
                if (formula == null) {
                    return;
                }
                FormulaExpression derived = (FormulaExpression)fe.getInstance();
                derived.setFormula(formula);
                expressionEditor.setSelectedItem(derived);
            } else if (selectedItem instanceof Expression) {
                ExpressionPropertiesDialog dialog = w instanceof Frame ? new ExpressionPropertiesDialog((Frame)w) : (w instanceof Dialog ? new ExpressionPropertiesDialog((Dialog)w) : new ExpressionPropertiesDialog());
                Expression expression = dialog.editExpression((Expression)selectedItem, ExpressionEditorPane.this.reportDesignerContext);
                if (expression != selectedItem) {
                    expressionEditor.setSelectedItem(expression);
                }
            } else if (selectedItem instanceof ExpressionMetaData) {
                try {
                    ExpressionMetaData emd = (ExpressionMetaData)selectedItem;
                    Expression expression = (Expression)emd.getExpressionType().newInstance();
                    ExpressionPropertiesDialog dialog = w instanceof Frame ? new ExpressionPropertiesDialog((Frame)w) : (w instanceof Dialog ? new ExpressionPropertiesDialog((Dialog)w) : new ExpressionPropertiesDialog());
                    Expression resultexpression = dialog.editExpression(expression, ExpressionEditorPane.this.reportDesignerContext);
                    if (resultexpression != expression) {
                        expressionEditor.setSelectedItem(resultexpression);
                    }
                }
                catch (Throwable e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                }
            } else {
                FormulaEditorDialog dialog = GUIUtils.createFormulaEditorDialog(ExpressionEditorPane.this.getReportDesignerContext(), ExpressionEditorPane.this);
                String formula = dialog.editFormula(null, ExpressionEditorPane.this.getFields());
                if (formula == null) {
                    return;
                }
                FormulaExpression derived = new FormulaExpression();
                derived.setFormula(formula);
                expressionEditor.setSelectedItem(derived);
            }
        }
    }
}

