/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class GridSizeDialog
extends CommonDialog {
    private JSpinner gridSizeSpinner;
    private JSpinner gridDivisionSpinner;
    private ComboBoxModel unitModel;
    private Unit unit;
    private static final Double ZERO = new Double(0.0);
    private static final Double STEP_SIZE = new Double(1.0);

    public GridSizeDialog() throws HeadlessException {
        this.init();
    }

    public GridSizeDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public GridSizeDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    private ComboBoxModel createUnitModel() {
        DefaultComboBoxModel<Unit> model = new DefaultComboBoxModel<Unit>(Unit.values());
        model.setSelectedItem((Object)Unit.POINTS);
        model.addListDataListener(new UnitChangeListener());
        return model;
    }

    protected ComboBoxModel getUnitModel() {
        return this.unitModel;
    }

    protected void init() {
        this.unit = Unit.POINTS;
        this.setTitle(UtilMessages.getInstance().getString("GridSizeDialog.Title"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.gridSizeSpinner = new JSpinner(new SpinnerNumberModel(ZERO, ZERO, null, STEP_SIZE));
        this.unitModel = this.createUnitModel();
        this.gridDivisionSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.GridSize";
    }

    protected JPanel createContentPane() {
        JPanel tablesPane = new JPanel();
        tablesPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)new JLabel(UtilMessages.getInstance().getString("GridSizeDialog.GridSize")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)this.gridSizeSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)new JLabel(UtilMessages.getInstance().getString("GridSizeDialog.GridDivision")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)this.gridDivisionSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)new JLabel(UtilMessages.getInstance().getString("GridSizeDialog.GridUnit")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add(new JComboBox(this.unitModel), gbc);
        return tablesPane;
    }

    public boolean showDialog() {
        return this.performEdit();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit newUnit) {
        if (newUnit == null) {
            throw new NullPointerException();
        }
        double gridSize = this.getGridSize();
        double gridDivision = this.getGridDivisionSize();
        if (newUnit != this.unitModel.getSelectedItem()) {
            this.unitModel.setSelectedItem((Object)newUnit);
        }
        this.unit = newUnit;
        this.setGridSize(gridSize);
        this.setGridDivisionSize(gridDivision);
    }

    public void setGridSize(double gridSize) {
        Unit unit = this.getUnit();
        this.gridSizeSpinner.setValue(new Double(unit.convertFromPoints(gridSize)));
    }

    public void setGridDivisionSize(double gridDivisionSize) {
        this.gridDivisionSpinner.setValue(gridDivisionSize);
    }

    public double getGridSize() {
        Object value = this.gridSizeSpinner.getValue();
        if (value instanceof Number) {
            Number n = (Number)value;
            return this.getUnit().convertToPoints(n.doubleValue());
        }
        return 0.0;
    }

    public int getGridDivisionSize() {
        Object value = this.gridDivisionSpinner.getValue();
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        return 0;
    }

    private class UnitChangeListener
    implements ListDataListener {
        private UnitChangeListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            Unit unit1 = (Unit)((Object)GridSizeDialog.this.getUnitModel().getSelectedItem());
            if (unit1 == null) {
                throw new IllegalStateException("Unit cannot be set to null");
            }
            GridSizeDialog.this.setUnit(unit1);
        }
    }
}

