/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.Window;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class ReportDesignerDesignTimeContext
implements DesignTimeContext {
    private ReportDesignerContext designerContext;
    private ReportDocumentContext activeContext;

    public ReportDesignerDesignTimeContext(ReportDesignerContext designerContext) {
        if (designerContext == null) {
            throw new NullPointerException();
        }
        this.designerContext = designerContext;
        this.activeContext = this.designerContext.getActiveContext();
        if (this.activeContext == null) {
            throw new NullPointerException();
        }
    }

    public AbstractReportDefinition getReport() {
        return this.activeContext.getReportDefinition();
    }

    public Window getParentWindow() {
        Component component = this.designerContext.getView().getParent();
        if (component instanceof Window) {
            return (Window)component;
        }
        return LibSwingUtil.getWindowAncestor((Component)component);
    }

    public DataSchemaModel getDataSchemaModel() {
        return this.activeContext.getReportDataSchemaModel();
    }

    public void error(Exception e) {
        UncaughtExceptionsModel.getInstance().addException(e);
    }

    public void userError(Exception e) {
        UncaughtExceptionsModel.getInstance().addException(e);
    }

    public LocaleSettings getLocaleSettings() {
        return WorkspaceSettings.getInstance();
    }

    public boolean isShowExpertItems() {
        return WorkspaceSettings.getInstance().isShowExpertItems();
    }

    public boolean isShowDeprecatedItems() {
        return WorkspaceSettings.getInstance().isShowDeprecatedItems();
    }

    public MaturityLevel getMaturityLevel() {
        return WorkspaceSettings.getInstance().getMaturityLevel();
    }

    public DataFactoryContext getDataFactoryContext() {
        return new DesignTimeDataFactoryContext((MasterReport)this.activeContext.getContextRoot());
    }
}

