/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.dnd;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.designtime.swing.GenericTransferable;

public class ClipboardManager
implements ClipboardOwner {
    private EventListenerList listeners = new EventListenerList();
    private static ClipboardManager manager;
    private Clipboard clipboard;
    private static final Log logger;

    public static synchronized ClipboardManager getManager() {
        if (manager == null) {
            manager = new ClipboardManager();
        }
        return manager;
    }

    private ClipboardManager() {
        try {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException se) {
            logger.error((Object)"Failed to create clipboard", (Throwable)se);
            this.clipboard = new Clipboard("local-clipboard");
        }
    }

    public Object[] getContents() throws UnsupportedFlavorException, IOException {
        try {
            if (this.clipboard.isDataFlavorAvailable(GenericTransferable.ELEMENT_FLAVOR)) {
                return (Object[])this.clipboard.getData(GenericTransferable.ELEMENT_FLAVOR);
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        return null;
    }

    public void setRawContent(Transferable t) {
        try {
            this.clipboard.setContents(t, this);
            this.fireContentsChanged();
        }
        catch (Exception ie) {
            UncaughtExceptionsModel.getInstance().addException(ie);
        }
    }

    public Transferable getRawContent() {
        try {
            return this.clipboard.getContents(this);
        }
        catch (Exception ie) {
            UncaughtExceptionsModel.getInstance().addException(ie);
            return null;
        }
    }

    public void setContents(Object[] contents) {
        try {
            this.clipboard.setContents((Transferable)new GenericTransferable(contents), this);
            this.fireContentsChanged();
        }
        catch (Exception ie) {
            UncaughtExceptionsModel.getInstance().addException(ie);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.fireContentsChanged();
        logger.debug((Object)("Lost ownership:" + contents));
    }

    private void fireContentsChanged() {
        ChangeListener[] changeListeners = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener changeListener = changeListeners[i];
            changeListener.stateChanged(event);
        }
    }

    public boolean isDataAvailable() {
        try {
            return this.clipboard.isDataFlavorAvailable(GenericTransferable.ELEMENT_FLAVOR);
        }
        catch (Exception ie) {
            UncaughtExceptionsModel.getInstance().addException(ie);
            return false;
        }
    }

    public void addChangeListener(ChangeListener c) {
        this.listeners.add(ChangeListener.class, c);
    }

    public void removeChangeListener(ChangeListener c) {
        this.listeners.remove(ChangeListener.class, c);
    }

    static {
        logger = LogFactory.getLog(ClipboardManager.class);
    }
}

