/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericDNDHandler
implements DropTargetListener {
    private static final Log logger = LogFactory.getLog(GenericDNDHandler.class);
    private Point position;
    private Object transferData;
    private DataFlavor flavor;
    private DataFlavor[] acceptedFlavors;

    public GenericDNDHandler(DataFlavor[] acceptedFlavors) {
        if (acceptedFlavors == null) {
            throw new NullPointerException();
        }
        this.acceptedFlavors = (DataFlavor[])acceptedFlavors.clone();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        for (int i = 0; i < this.acceptedFlavors.length; ++i) {
            DataFlavor acceptedFlavor = this.acceptedFlavors[i];
            if (!transferable.isDataFlavorSupported(acceptedFlavor)) continue;
            try {
                this.transferData = transferable.getTransferData(acceptedFlavor);
                this.position = dtde.getLocation();
                this.flavor = acceptedFlavor;
                int result = this.updateDragOver(dtde);
                if (result > 0) {
                    dtde.acceptDrag(1);
                    break;
                }
                this.transferData = null;
                this.position = null;
                this.flavor = null;
                dtde.rejectDrag();
                break;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"ReportPanel.dragOver ", (Throwable)e);
                }
                this.transferData = null;
                this.position = null;
                this.flavor = null;
                dtde.rejectDrag();
            }
        }
    }

    public Point getPosition() {
        return this.position;
    }

    public Object getTransferData() {
        return this.transferData;
    }

    public DataFlavor getFlavor() {
        return this.flavor;
    }

    protected int updateDragOver(DropTargetDragEvent event) {
        return 1;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.transferData = null;
        this.position = null;
        this.flavor = null;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.rejectDrop();
        this.transferData = null;
        this.position = null;
        this.flavor = null;
    }

    public void cleanup() {
        this.transferData = null;
        this.position = null;
        this.flavor = null;
    }
}

