/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pentaho.reporting.designer.core.util.docking.GradientPanel;

public class DefaultHeaderComponent
extends GradientPanel {
    private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";
    private FocusManagerChangeHandler target;
    private double darkeningFactor;

    public DefaultHeaderComponent(String category) {
        this(category, new Insets(1, 1, 1, 1), 0.9);
    }

    public DefaultHeaderComponent(String title, Insets insets, double darkeningFactor) {
        this.darkeningFactor = darkeningFactor;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getDarkerColor(this.getBackground())));
        this.setGradientColors(new Color[]{this.getDarkerColor(this.getBackground()), this.getBackground()});
        this.setDirection(GradientPanel.Direction.DIRECTION_LEFT);
        JLabel headerLabel = new JLabel(title);
        headerLabel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.add((Component)headerLabel, "Center");
        FocusManager currentManager = FocusManager.getCurrentManager();
        this.target = new FocusManagerChangeHandler();
        currentManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER, this.target);
    }

    public void setFocused(boolean b) {
        if (!b) {
            this.setGradientColors(new Color[]{this.getDarkerColor(this.getBackground()), this.getBackground()});
        } else {
            Color bg = UIManager.getColor("List.selectionBackground");
            Color fg = UIManager.getColor("List.background");
            if (bg != null && fg != null) {
                this.setGradientColors(new Color[]{bg, fg});
            }
        }
    }

    private Color getDarkerColor(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * this.darkeningFactor), 0), Math.max((int)((double)color.getGreen() * this.darkeningFactor), 0), Math.max((int)((double)color.getBlue() * this.darkeningFactor), 0));
    }

    public void dispose() {
        FocusManager.getCurrentManager().removePropertyChangeListener(PERMANENT_FOCUS_OWNER, this.target);
    }

    private class FocusManagerChangeHandler
    implements PropertyChangeListener {
        private FocusManagerChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof Component) {
                Component component = (Component)evt.getNewValue();
                if (SwingUtilities.isDescendingFrom(component, DefaultHeaderComponent.this)) {
                    DefaultHeaderComponent.this.setFocused(true);
                } else {
                    DefaultHeaderComponent.this.setFocused(false);
                }
            }
        }
    }
}

