/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.util.docking.Category;
import org.pentaho.reporting.designer.core.util.docking.SidePanel;

public class GlobalPane
extends JComponent {
    private SidePanel topPanel;
    private SidePanel leftPanel = new SidePanel(Alignment.LEFT);
    private SidePanel bottomPanel;
    private SidePanel rightPanel;
    private JPanel contentPane;

    public GlobalPane(boolean buttonsVisible) {
        this.leftPanel.setButtonsVisible(buttonsVisible);
        this.rightPanel = new SidePanel(Alignment.RIGHT);
        this.rightPanel.setButtonsVisible(buttonsVisible);
        this.topPanel = new SidePanel(Alignment.TOP);
        this.topPanel.setButtonsVisible(buttonsVisible);
        this.bottomPanel = new SidePanel(Alignment.BOTTOM);
        this.bottomPanel.setButtonsVisible(buttonsVisible);
        this.contentPane = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.rightPanel, "East");
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.add((Component)this.contentPane, "Center");
    }

    public void setMainComponent(Component component) {
        this.contentPane.removeAll();
        if (component != null) {
            this.contentPane.add(component);
        }
    }

    public Component getMainComponent() {
        if (this.contentPane.getComponentCount() == 0) {
            return null;
        }
        return this.contentPane.getComponent(0);
    }

    public void add(Alignment position, Category category) {
        if (position == null) {
            throw new NullPointerException();
        }
        switch (position) {
            case TOP: {
                this.topPanel.add(category);
                break;
            }
            case LEFT: {
                this.leftPanel.add(category);
                break;
            }
            case BOTTOM: {
                this.bottomPanel.add(category);
                break;
            }
            case RIGHT: {
                this.rightPanel.add(category);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isButtonsVisible(Alignment position) {
        if (position == null) {
            throw new NullPointerException();
        }
        switch (position) {
            case TOP: {
                return this.topPanel.isButtonsVisible();
            }
            case LEFT: {
                return this.leftPanel.isButtonsVisible();
            }
            case BOTTOM: {
                return this.bottomPanel.isButtonsVisible();
            }
            case RIGHT: {
                return this.rightPanel.isButtonsVisible();
            }
        }
        throw new IllegalArgumentException();
    }

    public void setButtonsVisible(Alignment position, boolean visible) {
        if (position == null) {
            throw new NullPointerException();
        }
        switch (position) {
            case TOP: {
                this.topPanel.setButtonsVisible(visible);
                break;
            }
            case LEFT: {
                this.leftPanel.setButtonsVisible(visible);
                break;
            }
            case BOTTOM: {
                this.bottomPanel.setButtonsVisible(visible);
                break;
            }
            case RIGHT: {
                this.rightPanel.setButtonsVisible(visible);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setPreferredContentSize(Alignment position, Integer value) {
        if (position == null) {
            throw new NullPointerException();
        }
        switch (position) {
            case TOP: {
                this.topPanel.setPreferredContentSize(value);
                break;
            }
            case LEFT: {
                this.leftPanel.setPreferredContentSize(value);
                break;
            }
            case BOTTOM: {
                this.bottomPanel.setPreferredContentSize(value);
                break;
            }
            case RIGHT: {
                this.rightPanel.setPreferredContentSize(value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Integer getPreferredContentSize(Alignment position) {
        if (position == null) {
            throw new NullPointerException();
        }
        switch (position) {
            case TOP: {
                return this.topPanel.getPreferredContentSize();
            }
            case LEFT: {
                return this.leftPanel.getPreferredContentSize();
            }
            case BOTTOM: {
                return this.bottomPanel.getPreferredContentSize();
            }
            case RIGHT: {
                return this.rightPanel.getPreferredContentSize();
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum Alignment {
        TOP(1),
        BOTTOM(1),
        LEFT(0),
        RIGHT(0);

        private int direction;

        private Alignment(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }
    }
}

