/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.util.docking.Category;
import org.pentaho.reporting.designer.core.util.docking.GlobalPane;
import org.pentaho.reporting.designer.core.util.docking.ImageToggleButton;
import org.pentaho.reporting.designer.core.util.docking.SideWindowCarrierPanel;

public class SidePanel
extends JComponent {
    private SideWindowCarrierPanel windowContent;
    private JComponent buttons;
    private GlobalPane.Alignment alignment;

    public SidePanel(GlobalPane.Alignment alignment) {
        this.alignment = alignment;
        this.windowContent = new SideWindowCarrierPanel(alignment);
        this.buttons = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.windowContent, "Center");
        switch (alignment) {
            case TOP: {
                this.buttons.setLayout(new BoxLayout(this.buttons, 0));
                this.add((Component)this.buttons, "North");
                break;
            }
            case BOTTOM: {
                this.buttons.setLayout(new BoxLayout(this.buttons, 0));
                this.add((Component)this.buttons, "South");
                break;
            }
            case LEFT: {
                this.buttons.setLayout(new BoxLayout(this.buttons, 1));
                this.add((Component)this.buttons, "West");
                break;
            }
            case RIGHT: {
                this.buttons.setLayout(new BoxLayout(this.buttons, 1));
                this.add((Component)this.buttons, "East");
            }
        }
    }

    public void add(Category category) {
        String title = category.getTitle();
        ImageIcon icon = category.getIconBig();
        JComponent component = category.getMainComponent();
        ImageToggleButton button = new ImageToggleButton(icon, title, this.alignment);
        button.setSelected(component.isVisible());
        button.addActionListener(new ToggleVisibleAction(button, category));
        this.buttons.add(button);
        this.windowContent.addWindow(category);
    }

    public void setPreferredContentSize(Integer value) {
        this.windowContent.setPreferredContentSize(value);
    }

    public Integer getPreferredContentSize() {
        return this.windowContent.getPreferredContentSize();
    }

    public boolean isButtonsVisible() {
        return this.buttons.isVisible();
    }

    public void setButtonsVisible(boolean visible) {
        this.buttons.setVisible(visible);
        this.revalidate();
    }

    private class ToggleVisibleAction
    implements ActionListener {
        private Category component;
        private ImageToggleButton button;

        private ToggleVisibleAction(ImageToggleButton button, Category component) {
            this.button = button;
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.component.setMinimized(!this.component.isMinimized());
            this.button.setSelected(!this.component.isMinimized());
        }
    }
}

