/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.exceptions;

import java.util.ArrayList;
import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionModelListener;
import org.pentaho.reporting.libraries.designtime.swing.WeakEventListenerList;

public class UncaughtExceptionsModel {
    private static final Log LOG = LogFactory.getLog(UncaughtExceptionsModel.class);
    private static final int MAXIMUM_SIZE = 100;
    private static final UncaughtExceptionsModel instance = new UncaughtExceptionsModel();
    private WeakEventListenerList uncaughtExceptionModelListeners = new WeakEventListenerList();
    private ArrayList<Throwable> throwables = new ArrayList();

    public static UncaughtExceptionsModel getInstance() {
        return instance;
    }

    public void addException(Throwable throwable) {
        LOG.error((Object)UtilMessages.getInstance().getString("UncaughtExcpetionsModel.AddException"), throwable);
        this.throwables.add(throwable);
        if (this.throwables.size() > 100) {
            this.throwables.remove(0);
        }
        this.fireExceptionAdded(throwable);
    }

    private void fireExceptionAdded(Throwable throwable) {
        UncaughtExceptionModelListener[] listeners = (UncaughtExceptionModelListener[])this.uncaughtExceptionModelListeners.getListeners(UncaughtExceptionModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            UncaughtExceptionModelListener listener = listeners[i];
            listener.exceptionCaught(throwable);
        }
    }

    public Throwable[] getThrowables() {
        return this.throwables.toArray(new Throwable[this.throwables.size()]);
    }

    public void addUncaughtExceptionModelListener(UncaughtExceptionModelListener uncaughtExceptionModelListener) {
        this.uncaughtExceptionModelListeners.add(UncaughtExceptionModelListener.class, (EventListener)uncaughtExceptionModelListener);
    }

    public void removeUncaughtExceptionModelListener(UncaughtExceptionModelListener uncaughtExceptionModelListener) {
        this.uncaughtExceptionModelListeners.remove(UncaughtExceptionModelListener.class, (EventListener)uncaughtExceptionModelListener);
    }

    public void clearExceptions() {
        this.throwables.clear();
        UncaughtExceptionModelListener[] listeners = (UncaughtExceptionModelListener[])this.uncaughtExceptionModelListeners.getListeners(UncaughtExceptionModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            UncaughtExceptionModelListener listener = listeners[i];
            listener.exceptionsCleared();
        }
    }

    public void exceptionsViewed() {
        UncaughtExceptionModelListener[] listeners = (UncaughtExceptionModelListener[])this.uncaughtExceptionModelListeners.getListeners(UncaughtExceptionModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            UncaughtExceptionModelListener listener = listeners[i];
            listener.exceptionsViewed();
        }
    }
}

