/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.firewall;

import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.UtilMessages;

public class FirewallingSecurityManager
extends SecurityManager {
    private SecurityManager parent = System.getSecurityManager();
    private PermissionCollection permissionCollection;
    private static final String PERMISSION_VALUE = "accept,listen,connect,resolve";
    private static final String LOCALHOST = "localhost";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final String LOCALHOST_LOCALDOMAIN = "localhost.localdomain";

    public FirewallingSecurityManager() {
        SocketPermission localHost = new SocketPermission(LOCALHOST, PERMISSION_VALUE);
        SocketPermission localHostRaw = new SocketPermission(LOCALHOST_IP, PERMISSION_VALUE);
        SocketPermission localHostFqn = new SocketPermission(LOCALHOST_LOCALDOMAIN, PERMISSION_VALUE);
        this.permissionCollection = localHost.newPermissionCollection();
        this.permissionCollection.add(localHost);
        this.permissionCollection.add(localHostRaw);
        this.permissionCollection.add(localHostFqn);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (WorkspaceSettings.getInstance().isOfflineMode() && perm instanceof SocketPermission && !this.permissionCollection.implies(perm)) {
            throw new SecurityException(UtilMessages.getInstance().getString("FirewallingProxySelector.FilterMessage"));
        }
        if (this.parent != null) {
            this.parent.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (WorkspaceSettings.getInstance().isOfflineMode() && perm instanceof SocketPermission && !this.permissionCollection.implies(perm)) {
            throw new SecurityException(UtilMessages.getInstance().getString("FirewallingProxySelector.FilterMessage"));
        }
        if (this.parent != null) {
            this.parent.checkPermission(perm, context);
        }
    }
}

