/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorDialog;
import org.pentaho.openformula.ui.util.FieldDefinitionCellRenderer;
import org.pentaho.openformula.ui.util.FieldSelectorDialog;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.DateFormatModel;
import org.pentaho.reporting.designer.core.settings.NumberFormatModel;
import org.pentaho.reporting.designer.core.util.GUIUtils;
import org.pentaho.reporting.designer.core.util.GroupSelectorDialog;
import org.pentaho.reporting.designer.core.util.QuerySelectorDialog;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.CellEditorUtility;
import org.pentaho.reporting.designer.core.util.table.TextAreaPropertyEditorDialog;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.GenericExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultProcessingContext;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.EmptyValueListCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.NonFilteringPlainDocument;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public abstract class AbstractStringValueCellEditor
extends JPanel
implements CellEditor {
    protected static final String CONFIRM_EDITOR = "confirmEditor";
    protected static final String POPUP_EDITOR = "popupEditor";
    protected static final String CANCEL_EDITOR = "cancelEditor";
    protected static final String NEWLINE_EDITOR = "newlineEditor";
    private static final String RESOURCE_VALUE_ROLE = "Resource";
    private static final String FIELD_VALUE_ROLE = "Field";
    private static final String QUERY_VALUE_ROLE = "Query";
    private static final String GROUP_VALUE_ROLE = "Group";
    private static final String FORMULA_VALUE_ROLE = "Formula";
    private static final String NUMBER_FORMAT_VALUE_ROLE = "NumberFormat";
    private static final String DATE_FORMAT_VALUE_ROLE = "DateFormat";
    protected static final String[] EMPTY_EXTRA_FIELDS = new String[0];
    protected static final FieldDefinition[] EMPTY_FIELDS = new FieldDefinition[0];
    private JTextArea textField;
    private JButton ellipsisButton;
    private EventListenerList eventListenerList;
    private boolean nullable;
    private String valueRole;
    private JComboBox comboBox;
    private DefaultDataAttributeContext dataAttributeContext;
    private transient Object originalValue;
    private volatile boolean filterEvents;
    private boolean comboBoxActive;
    private boolean formulaFragment;
    private String[] extraFields;
    private ReportDesignerContext designerContext;
    private MasterReport currentMasterReport;
    private ReportModelChangeHandler modelChangeHandler;

    public AbstractStringValueCellEditor() {
        BasicComboBoxEditor basicComboBoxEditor;
        Component editorComponent;
        this.setLayout(new BorderLayout());
        this.modelChangeHandler = new ReportModelChangeHandler();
        Action action = this.createExtendedEditorAction();
        this.eventListenerList = new EventListenerList();
        this.dataAttributeContext = new DefaultDataAttributeContext();
        this.extraFields = EMPTY_EXTRA_FIELDS;
        this.ellipsisButton = new EllipsisButton("...");
        this.ellipsisButton.addActionListener(action);
        this.textField = new JTextArea();
        this.textField.setLineWrap(true);
        this.textField.setDocument((Document)new NonFilteringPlainDocument());
        this.textField.getInputMap().put(UtilMessages.getInstance().getKeyStroke("AbstractStringValueCellEditor.Popup.Accelerator"), POPUP_EDITOR);
        this.textField.getActionMap().put(POPUP_EDITOR, action);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), CANCEL_EDITOR);
        this.textField.getActionMap().put(CANCEL_EDITOR, new CancelAction());
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 1), NEWLINE_EDITOR);
        this.textField.getActionMap().put(NEWLINE_EDITOR, new InsertNewLineAction());
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), CONFIRM_EDITOR);
        this.textField.getActionMap().put(CONFIRM_EDITOR, new SelectionAction());
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.comboBox = new JComboBox();
        ComboBoxEditor boxEditor = this.comboBox.getEditor();
        if (boxEditor instanceof BasicComboBoxEditor && (editorComponent = (basicComboBoxEditor = (BasicComboBoxEditor)boxEditor).getEditorComponent()) instanceof JTextField) {
            JTextField editorTextField = (JTextField)editorComponent;
            editorTextField.setDocument((Document)new NonFilteringPlainDocument());
        }
        this.comboBox.setRenderer(new EmptyValueListCellRenderer());
        this.comboBox.addActionListener(new SelectionAction());
        this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(27, 0), new CancelAction());
        this.comboBox.getInputMap().put(UtilMessages.getInstance().getKeyStroke("AbstractStringValueCellEditor.Popup.Accelerator"), POPUP_EDITOR);
        this.comboBox.setBorder(BorderFactory.createEmptyBorder());
        this.comboBox.setEditable(true);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.ellipsisButton, "East");
        this.nullable = false;
    }

    public boolean isFormulaFragment() {
        return this.formulaFragment;
    }

    public void setFormulaFragment(boolean formulaFragment) {
        this.formulaFragment = formulaFragment;
    }

    protected Action createExtendedEditorAction() {
        return new ExtendedEditorAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component create(String valueRole, String[] extraFields, Object value) {
        ReportRenderContext reportContext = this.getReportContext();
        if (reportContext != null) {
            this.currentMasterReport = reportContext.getMasterReportElement();
            this.currentMasterReport.addReportModelListener((ReportModelListener)this.modelChangeHandler);
        }
        try {
            this.filterEvents = true;
            this.setExtraFields(extraFields);
            if (QUERY_VALUE_ROLE.equals(valueRole)) {
                this.comboBox.setModel(new DefaultComboBoxModel<String>(this.getQueryNames()));
                this.comboBox.setRenderer(new EmptyValueListCellRenderer());
                this.comboBox.setEditable(true);
                this.add((Component)this.comboBox, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.comboBox.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = true;
            } else if (FIELD_VALUE_ROLE.equals(valueRole)) {
                this.comboBox.setModel(new DefaultComboBoxModel<FieldDefinition>(this.getFields()));
                this.comboBox.setRenderer(new FieldDefinitionCellRenderer());
                this.comboBox.setEditable(true);
                this.add((Component)this.comboBox, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.comboBox.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = true;
            } else if (GROUP_VALUE_ROLE.equals(valueRole)) {
                this.comboBox.setModel(new DefaultComboBoxModel<String>(this.getGroups()));
                this.comboBox.setRenderer(new EmptyValueListCellRenderer());
                this.comboBox.setEditable(true);
                this.add((Component)this.comboBox, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.comboBox.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = true;
            } else if (NUMBER_FORMAT_VALUE_ROLE.equals(valueRole)) {
                this.comboBox.setModel(new DefaultComboBoxModel<String>(new NumberFormatModel().getNumberFormats()));
                this.comboBox.setRenderer(new EmptyValueListCellRenderer());
                this.comboBox.setEditable(true);
                this.add((Component)this.comboBox, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.comboBox.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = true;
            } else if (DATE_FORMAT_VALUE_ROLE.equals(valueRole)) {
                this.comboBox.setModel(new DefaultComboBoxModel<String>(new DateFormatModel().getNumberFormats()));
                this.comboBox.setRenderer(new EmptyValueListCellRenderer());
                this.comboBox.setEditable(true);
                this.add((Component)this.comboBox, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.comboBox.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = true;
            } else if (FORMULA_VALUE_ROLE.equals(valueRole)) {
                DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
                FieldDefinition[] definitions = this.getFields();
                for (int i = 0; i < definitions.length; ++i) {
                    FieldDefinition fieldDefinition = definitions[i];
                    comboBoxModel.addElement("=" + FormulaUtil.quoteReference((String)fieldDefinition.getName()));
                }
                this.comboBox.setModel(comboBoxModel);
                this.comboBox.setRenderer(new EmptyValueListCellRenderer());
                this.comboBox.setEditable(true);
                this.add((Component)this.comboBox, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.comboBox.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = true;
            } else {
                this.add((Component)this.textField, "Center");
                this.add((Component)this.ellipsisButton, "East");
                this.textField.requestFocus();
                this.setValueRole(valueRole);
                this.comboBoxActive = false;
            }
            if (value == null) {
                this.comboBox.setSelectedItem(null);
                this.textField.setText(null);
            } else if (FORMULA_VALUE_ROLE.equals(valueRole) && this.isFormulaFragment()) {
                GenericExpressionRuntime expressionRuntime = new GenericExpressionRuntime((DataRow)new StaticDataRow(), (TableModel)new DefaultTableModel(), -1, (ProcessingContext)new DefaultProcessingContext());
                String formulaText = FormulaUtil.createEditorTextFromFormula((String)String.valueOf(value), (FormulaContext)new ReportFormulaContext((FormulaContext)new DefaultFormulaContext(), (ExpressionRuntime)expressionRuntime));
                this.textField.setText(formulaText);
                this.comboBox.setSelectedItem(formulaText);
            } else {
                this.comboBox.setSelectedItem(value);
                this.textField.setText(String.valueOf(value));
            }
            this.originalValue = value;
            AbstractStringValueCellEditor abstractStringValueCellEditor = this;
            return abstractStringValueCellEditor;
        }
        finally {
            this.filterEvents = false;
        }
    }

    protected void configureEditorStyle(Font font, Color foreground, Color background) {
        this.comboBox.setFont(font);
        this.comboBox.setForeground(foreground);
        this.comboBox.setBackground(background);
        this.textField.setFont(font);
        this.textField.setForeground(foreground);
        this.textField.setBackground(background);
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    protected boolean isNullable() {
        return this.nullable;
    }

    protected void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    protected JTextComponent getTextField() {
        return this.textField;
    }

    protected JButton getEllipsisButton() {
        return this.ellipsisButton;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.comboBoxActive) {
            Object selectedItem = this.comboBox.getSelectedItem();
            if (selectedItem instanceof FieldDefinition) {
                FieldDefinition fieldDefinition = (FieldDefinition)selectedItem;
                return fieldDefinition.getName();
            }
            if ("".equals(selectedItem)) {
                return null;
            }
            if (selectedItem instanceof String && FORMULA_VALUE_ROLE.equals(this.getValueRole()) && this.isFormulaFragment()) {
                return FormulaUtil.createFormulaFromUIText((String)((String)selectedItem));
            }
            return selectedItem;
        }
        String s = this.textField.getText();
        if ("".equals(s)) {
            return null;
        }
        if (FORMULA_VALUE_ROLE.equals(this.getValueRole()) && this.isFormulaFragment()) {
            return FormulaUtil.createFormulaFromUIText((String)s);
        }
        return s;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCellEditing() {
        try {
            if (this.comboBoxActive) {
                this.comboBox.actionPerformed(new ActionEvent(this, 1001, this.comboBox.getActionCommand()));
            }
            this.fireEditingStopped();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            DebugLog.log((Object)"Exception caught while editing cell-value", (Throwable)e);
            this.fireEditingCanceled();
            if (this.originalValue != null) {
                this.textField.setText(String.valueOf(this.originalValue));
            } else {
                this.textField.setText(null);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unregisterListener();
        }
    }

    protected void unregisterListener() {
        if (this.currentMasterReport != null) {
            this.currentMasterReport.removeReportModelListener((ReportModelListener)this.modelChangeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCellEditing() {
        try {
            if (this.originalValue != null) {
                this.textField.setText(String.valueOf(this.originalValue));
            } else {
                this.textField.setText(null);
            }
            try {
                this.filterEvents = true;
                this.comboBox.setSelectedItem(this.originalValue);
            }
            finally {
                this.filterEvents = false;
            }
            this.fireEditingCanceled();
        }
        finally {
            this.unregisterListener();
        }
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    protected String getValueRole() {
        return this.valueRole;
    }

    protected void setValueRole(String valueRole) {
        this.valueRole = valueRole;
    }

    protected String[] getExtraFields() {
        return this.extraFields;
    }

    protected void setExtraFields(String[] extraFields) {
        this.extraFields = (String[])extraFields.clone();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    protected String[] getQueryNames() {
        return CellEditorUtility.getQueryNames(this.getReportDesignerContext());
    }

    public ReportRenderContext getReportContext() {
        if (this.designerContext == null) {
            return null;
        }
        ReportDocumentContext documentContext = this.designerContext.getActiveContext();
        if (documentContext instanceof ReportRenderContext) {
            return (ReportRenderContext)documentContext;
        }
        return null;
    }

    public void setReportDesignerContext(ReportDesignerContext designerContext) {
        this.designerContext = designerContext;
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.designerContext;
    }

    protected FieldDefinition[] getFields() {
        return CellEditorUtility.getFields(this.designerContext, this.getExtraFields());
    }

    protected String[] getGroups() {
        ReportRenderContext reportContext = this.getReportContext();
        if (reportContext == null) {
            return new String[0];
        }
        return ModelUtility.getGroups(reportContext.getReportDefinition());
    }

    private class ReportModelChangeHandler
    implements ReportModelListener {
        private ReportModelChangeHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            AbstractStringValueCellEditor.this.cancelCellEditing();
        }
    }

    private class InsertNewLineAction
    extends AbstractAction {
        private InsertNewLineAction() {
            this.putValue("Name", UtilMessages.getInstance().getString("AbstractStringValueCellEditor.InsertNewLine"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = AbstractStringValueCellEditor.this.getTextField();
            int position = textComponent.getCaretPosition();
            try {
                textComponent.getDocument().insertString(position, "\n", null);
            }
            catch (BadLocationException e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractStringValueCellEditor.this.cancelCellEditing();
        }
    }

    protected class SelectionAction
    extends AbstractAction {
        public SelectionAction() {
            this.putValue("Name", UtilMessages.getInstance().getString("AbstractStringValueCellEditor.SelectValue"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractStringValueCellEditor.this.filterEvents) {
                return;
            }
            AbstractStringValueCellEditor.this.stopCellEditing();
        }
    }

    protected class ExtendedEditorAction
    extends AbstractAction {
        protected ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String valueRole = AbstractStringValueCellEditor.this.getValueRole();
            JComboBox comboBox = AbstractStringValueCellEditor.this.getComboBox();
            if (AbstractStringValueCellEditor.RESOURCE_VALUE_ROLE.equals(valueRole)) {
                FileFilter[] filters = new FileFilter[]{new FilesystemFilter(".properties", Messages.getString("BundledResourceEditor.PropertiesTranslations", new Object[0])), new FilesystemFilter(new String[]{".xml", ".report", ".prpt", ".prpti", ".prptstyle"}, Messages.getString("BundledResourceEditor.Resources", new Object[0]), true), new FilesystemFilter(new String[]{".gif", ".jpg", ".jpeg", ".png", ".svg", ".wmf"}, Messages.getString("BundledResourceEditor.Images", new Object[0]), true)};
                CommonFileChooser chooser = FileChooserService.getInstance().getFileChooser("resources");
                chooser.setFilters(filters);
                String text = AbstractStringValueCellEditor.this.getTextField().getText();
                if (!StringUtils.isEmpty((String)text)) {
                    chooser.setSelectedFile(new File(text));
                }
                if (chooser.showDialog((Component)AbstractStringValueCellEditor.this, 0)) {
                    File file = chooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    ReportRenderContext reportRenderContext = AbstractStringValueCellEditor.this.getReportContext();
                    if (reportRenderContext == null) {
                        AbstractStringValueCellEditor.this.getTextField().setText(file.getPath());
                    } else {
                        File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)reportRenderContext.getReportDefinition());
                        String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
                        AbstractStringValueCellEditor.this.getTextField().setText(path);
                    }
                }
            } else if (AbstractStringValueCellEditor.FIELD_VALUE_ROLE.equals(valueRole)) {
                FieldDefinition fieldDefinition;
                Window window = LibSwingUtil.getWindowAncestor((Component)AbstractStringValueCellEditor.this);
                FieldSelectorDialog editorDialog = window instanceof Frame ? new FieldSelectorDialog((Frame)window) : (window instanceof Dialog ? new FieldSelectorDialog((Dialog)window) : new FieldSelectorDialog());
                FieldDefinition[] fields = AbstractStringValueCellEditor.this.getFields();
                String selectedItem = (String)comboBox.getSelectedItem();
                FieldDefinition selected = null;
                if (selectedItem != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        FieldDefinition field = fields[i];
                        if (!selectedItem.equals(field.getName())) continue;
                        selected = field;
                        break;
                    }
                }
                if ((fieldDefinition = editorDialog.performEdit(fields, selected)) != null) {
                    comboBox.setSelectedItem(fieldDefinition.getName());
                }
            } else if (AbstractStringValueCellEditor.QUERY_VALUE_ROLE.equals(valueRole)) {
                Window window = LibSwingUtil.getWindowAncestor((Component)AbstractStringValueCellEditor.this);
                QuerySelectorDialog editorDialog = window instanceof Frame ? new QuerySelectorDialog((Frame)window) : (window instanceof Dialog ? new QuerySelectorDialog((Dialog)window) : new QuerySelectorDialog());
                String selectedQuery = editorDialog.performEdit(AbstractStringValueCellEditor.this.getQueryNames(), (String)comboBox.getSelectedItem());
                if (editorDialog.isConfirmed()) {
                    comboBox.setSelectedItem(selectedQuery);
                }
            } else if (AbstractStringValueCellEditor.GROUP_VALUE_ROLE.equals(valueRole)) {
                Window window = LibSwingUtil.getWindowAncestor((Component)AbstractStringValueCellEditor.this);
                GroupSelectorDialog editorDialog = window instanceof Frame ? new GroupSelectorDialog((Frame)window) : (window instanceof Dialog ? new GroupSelectorDialog((Dialog)window) : new GroupSelectorDialog());
                String originalGroup = (String)comboBox.getSelectedItem();
                String selectedGroup = editorDialog.performEdit(AbstractStringValueCellEditor.this.getGroups(), originalGroup);
                if (editorDialog.isConfirmed()) {
                    comboBox.setSelectedItem(selectedGroup);
                }
            } else if (AbstractStringValueCellEditor.FORMULA_VALUE_ROLE.equals(valueRole)) {
                String originalFormula;
                FormulaEditorDialog editorDialog = GUIUtils.createFormulaEditorDialog(AbstractStringValueCellEditor.this.getReportDesignerContext(), AbstractStringValueCellEditor.this);
                String formula = editorDialog.editFormula(originalFormula = (String)comboBox.getSelectedItem(), AbstractStringValueCellEditor.this.getFields());
                if (formula != null) {
                    comboBox.setSelectedItem(formula);
                }
            } else if (AbstractStringValueCellEditor.NUMBER_FORMAT_VALUE_ROLE.equals(valueRole) || AbstractStringValueCellEditor.DATE_FORMAT_VALUE_ROLE.equals(valueRole)) {
                Window window = LibSwingUtil.getWindowAncestor((Component)AbstractStringValueCellEditor.this);
                TextAreaPropertyEditorDialog editorDialog = window instanceof Frame ? new TextAreaPropertyEditorDialog((Frame)window) : (window instanceof Dialog ? new TextAreaPropertyEditorDialog((Dialog)window) : new TextAreaPropertyEditorDialog());
                String originalFormula = (String)comboBox.getSelectedItem();
                String text = editorDialog.performEdit(originalFormula);
                if (editorDialog.isConfirmed()) {
                    comboBox.setSelectedItem(text);
                }
            } else {
                Window window = LibSwingUtil.getWindowAncestor((Component)AbstractStringValueCellEditor.this);
                TextAreaPropertyEditorDialog editorDialog = window instanceof Frame ? new TextAreaPropertyEditorDialog((Frame)window) : (window instanceof Dialog ? new TextAreaPropertyEditorDialog((Dialog)window) : new TextAreaPropertyEditorDialog());
                JTextComponent textField = AbstractStringValueCellEditor.this.getTextField();
                String originalValue = textField.getText();
                String text = editorDialog.performEdit(originalValue);
                if (editorDialog.isConfirmed()) {
                    textField.setText(text);
                }
            }
            AbstractStringValueCellEditor.this.stopCellEditing();
        }
    }
}

