/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.Locale;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorRegistry;

public class ArrayAccessUtility {
    public static boolean isArray(Object array) {
        if (array == null) {
            return false;
        }
        return array.getClass().isArray();
    }

    public static Object[] normalizeArray(Object array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        Object[] retval = new Object[Array.getLength(array)];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Array.get(array, i);
        }
        return retval;
    }

    public static Object normalizeNative(Object[] data, Class arrayType) {
        Object array = Array.newInstance(arrayType, data.length);
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            if (o != null && !arrayType.isInstance(o)) {
                throw new ClassCastException("Object " + o + " cannot be cast to " + arrayType);
            }
            Array.set(array, i, o);
        }
        return array;
    }

    public static String getArrayAsString(Object array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            ExpressionMetaData metaData;
            Object value;
            if (i > 0) {
                b.append(", ");
            }
            if ((value = Array.get(array, i)) == null) {
                b.append("<null>");
                continue;
            }
            if (value instanceof String) {
                b.append(value);
                continue;
            }
            if (value instanceof Expression) {
                metaData = ExpressionRegistry.getInstance().getExpressionMetaData(value.getClass().getName());
                if (metaData != null) {
                    b.append(metaData.getDisplayName(Locale.getDefault()));
                    continue;
                }
                b.append(String.valueOf(value));
                continue;
            }
            if (value instanceof ReportElement) {
                Element element = (Element)value;
                ElementMetaData metaData2 = element.getElementType().getMetaData();
                if (metaData2 != null) {
                    b.append(metaData2.getDisplayName(Locale.getDefault()));
                    continue;
                }
                b.append(String.valueOf(value));
                continue;
            }
            if (value instanceof ReportPreProcessor) {
                metaData = ReportPreProcessorRegistry.getInstance().getReportPreProcessorMetaData(value.getClass().getName());
                if (metaData != null) {
                    b.append(metaData.getDisplayName(Locale.getDefault()));
                    continue;
                }
                b.append(String.valueOf(value));
                continue;
            }
            PropertyEditor propertyEditor = FastPropertyEditorManager.findEditor(value.getClass());
            if (propertyEditor != null) {
                propertyEditor.setValue(value);
                b.append(propertyEditor.getAsText());
                continue;
            }
            b.append(value);
        }
        b.append(']');
        return b.toString();
    }
}

