/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;

public class ArrayTableModel
extends AbstractTableModel
implements BulkDataProvider,
ElementMetaDataTableModel {
    private ArrayList<Object> data = new ArrayList();
    private Class type = Object.class;
    private String valueRole;
    private Class propertyEditorType;
    private String[] extraFields = new String[0];
    private String columnTitle = UtilMessages.getInstance().getString("ArrayTableModel.Value");
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getColumnTitle() {
        return this.columnTitle;
    }

    public void setColumnTitle(String columnTitle) {
        this.columnTitle = columnTitle;
    }

    public Object[] getData() {
        return this.data.toArray();
    }

    public <T> void setData(T[] data, Class<T> componentType) {
        if (componentType == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.data.clear();
        this.data.addAll(Arrays.asList(data));
        this.type = componentType;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.data.set(rowIndex, aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable;
    }

    public Class getColumnClass(int columnIndex) {
        return this.type;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnTitle;
    }

    public void add(Object o) {
        this.data.add(o);
        this.fireTableDataChanged();
    }

    public void add(int idx, Object item) {
        this.data.add(idx, item);
        this.fireTableDataChanged();
    }

    public Object get(int index) {
        return this.data.get(index);
    }

    public void remove(int index) {
        this.data.remove(index);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public Object[] toArray() {
        return this.getData();
    }

    public int getSize() {
        return this.getRowCount();
    }

    public int getBulkDataSize() {
        return this.getRowCount();
    }

    public Object[] getBulkData() {
        return this.getData();
    }

    public void setBulkData(Object[] data) {
        this.setData(data, this.type);
    }

    public Class getClassForCell(int row, int column) {
        return this.type;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getPropertyEditorType() {
        return this.propertyEditorType;
    }

    public void setPropertyEditorType(Class propertyEditorType) {
        this.propertyEditorType = propertyEditorType;
    }

    public PropertyEditor getEditorForCell(int row, int column) {
        if (this.propertyEditorType == null) {
            return null;
        }
        try {
            return (PropertyEditor)this.propertyEditorType.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValueRole(String valueRole) {
        this.valueRole = valueRole;
    }

    @Override
    public String getValueRole(int row, int column) {
        return this.valueRole;
    }

    public void setExtraFields(String[] extraFields) {
        this.extraFields = (String[])extraFields.clone();
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        return (String[])this.extraFields.clone();
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
    }

    @Override
    public TableStyle getTableStyle() {
        return TableStyle.ASCENDING;
    }
}

