/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.DataSchemaUtility;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.DataSchemaFieldDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;

public class CellEditorUtility {
    private CellEditorUtility() {
    }

    public static String[] getExcelColorsAsText() {
        Color[] excelColors = ColorUtility.getPredefinedExcelColors();
        String[] textColors = new String[excelColors.length];
        for (int i = 0; i < excelColors.length; ++i) {
            Color excelColor = excelColors[i];
            String color = Integer.toHexString(excelColor.getRGB() & 0xFFFFFF);
            StringBuffer retval = new StringBuffer(7);
            retval.append('#');
            int fillUp = 6 - color.length();
            for (int x = 0; x < fillUp; ++x) {
                retval.append('0');
            }
            retval.append(color);
            textColors[i] = retval.toString();
        }
        return textColors;
    }

    public static String[] getQueryNames(ReportDesignerContext designerContext) {
        if (designerContext == null) {
            return new String[0];
        }
        ReportDocumentContext reportContext = designerContext.getActiveContext();
        if (reportContext == null) {
            return new String[0];
        }
        AbstractReportDefinition definition = reportContext.getReportDefinition();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        while (definition != null) {
            CompoundDataFactory dataFactoryElement = (CompoundDataFactory)definition.getDataFactory();
            int dataFactoryCount = dataFactoryElement.size();
            for (int i = 0; i < dataFactoryCount; ++i) {
                DataFactory dataFactory = dataFactoryElement.getReference(i);
                String[] queryNames = dataFactory.getQueryNames();
                names.addAll(Arrays.asList(queryNames));
            }
            if (definition instanceof SubReport) {
                Section parentSection = definition.getParentSection();
                definition = (AbstractReportDefinition)parentSection.getReportDefinition();
                continue;
            }
            definition = null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static FieldDefinition[] getFields(ReportDesignerContext designerContext, String[] extraFields) {
        if (designerContext == null) {
            return new FieldDefinition[0];
        }
        ReportDocumentContext reportContext = designerContext.getActiveContext();
        if (reportContext == null) {
            return new FieldDefinition[0];
        }
        return CellEditorUtility.getFields(reportContext, extraFields);
    }

    public static FieldDefinition[] getFields(ReportDocumentContext reportContext, String[] extraFields) {
        int i;
        ContextAwareDataSchemaModel model = reportContext.getReportDataSchemaModel();
        String[] columnNames = model.getColumnNames();
        ArrayList<DataSchemaFieldDefinition> fields = new ArrayList<DataSchemaFieldDefinition>(columnNames.length + extraFields.length);
        DataSchema dataSchema = model.getDataSchema();
        DefaultDataAttributeContext dataAttributeContext = new DefaultDataAttributeContext();
        for (i = 0; i < extraFields.length; ++i) {
            String extraField = extraFields[i];
            fields.add(new DataSchemaFieldDefinition(extraField, (DataAttributes)new EmptyDataAttributes(), (DataAttributeContext)dataAttributeContext));
        }
        for (i = columnNames.length - 1; i >= 0; --i) {
            String columnName = columnNames[i];
            DataAttributes attributes = dataSchema.getAttributes(columnName);
            if (attributes == null) {
                throw new IllegalStateException("No data-schema for field with name '" + columnName + '\'');
            }
            if (DataSchemaUtility.isFiltered(attributes, (DataAttributeContext)dataAttributeContext)) continue;
            fields.add(new DataSchemaFieldDefinition(columnName, attributes, (DataAttributeContext)dataAttributeContext));
        }
        return fields.toArray(new FieldDefinition[fields.size()]);
    }

    public static String[] getFieldsAsString(ReportDocumentContext designerContext, String[] extraFields) {
        FieldDefinition[] fields = CellEditorUtility.getFields(designerContext, extraFields);
        return CellEditorUtility.convertToColumnNames(fields);
    }

    public static String[] convertToColumnNames(FieldDefinition[] fields) {
        String[] fieldsAsString = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            FieldDefinition field = fields[i];
            fieldsAsString[i] = field.getName();
        }
        return fieldsAsString;
    }

    public static String[] getFieldsAsString(ReportDesignerContext designerContext, String[] extraFields) {
        FieldDefinition[] fields = CellEditorUtility.getFields(designerContext, extraFields);
        return CellEditorUtility.convertToColumnNames(fields);
    }

    public static String[] getGroups(ReportDesignerContext designerContext) {
        if (designerContext == null) {
            return new String[0];
        }
        ReportDocumentContext reportContext = designerContext.getActiveContext();
        if (reportContext == null) {
            return new String[0];
        }
        return ModelUtility.getGroups(reportContext.getReportDefinition());
    }
}

