/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;

public class GroupedTableModel
implements TableModel {
    private EventListenerList eventListenerList;
    private GroupingModel parent;
    private int rowCount;

    public GroupedTableModel(GroupingModel parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.eventListenerList = new EventListenerList();
        this.parent = parent;
        this.parent.addTableModelListener(new EventForwardHandler());
        this.recomputeRowCount();
    }

    protected void fireTableModelEvent(TableModelEvent event) {
        TableModelListener[] listeners = (TableModelListener[])this.eventListenerList.getListeners(TableModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            TableModelListener listener = listeners[i];
            listener.tableChanged(event);
        }
    }

    protected void recomputeRowCount() {
        this.rowCount = this.mapFromModel(this.parent.getRowCount());
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.parent.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.parent.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.parent.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        if (this.parent.isHeaderRow(index)) {
            return true;
        }
        return this.parent.isCellEditable(index, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.parent.getValueAt(this.mapToModel(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        if (this.parent.isHeaderRow(index)) {
            this.recomputeRowCount();
            this.fireTableModelEvent(new TableModelEvent(this));
            return;
        }
        this.parent.setValueAt(aValue, index, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.eventListenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.eventListenerList.remove(TableModelListener.class, l);
    }

    public int mapToModel(int row) {
        int size = this.parent.getRowCount();
        int effectiveRow = 0;
        for (int i = 0; i < size; ++i) {
            GroupingHeader groupHeader = this.parent.getGroupHeader(i);
            if (groupHeader != null && groupHeader.isCollapsed() && !this.parent.isHeaderRow(i)) continue;
            if (effectiveRow == row) {
                return i;
            }
            ++effectiveRow;
        }
        throw new IndexOutOfBoundsException("Unable to map row to model: " + row);
    }

    public int mapFromModel(int row) {
        if (row < 0) {
            return row;
        }
        int size = this.parent.getRowCount();
        int retval = 0;
        for (int i = 0; i < size; ++i) {
            GroupingHeader groupHeader = this.parent.getGroupHeader(i);
            if (groupHeader == null || !groupHeader.isCollapsed() || this.parent.isHeaderRow(i)) {
                if (row == i) {
                    return retval;
                }
                ++retval;
                continue;
            }
            if (!groupHeader.isCollapsed() || row != i) continue;
            return retval - 1;
        }
        return retval;
    }

    private class EventForwardHandler
    implements TableModelListener {
        private EventForwardHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            GroupedTableModel.this.recomputeRowCount();
            if (e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE) {
                GroupedTableModel.this.fireTableModelEvent(new TableModelEvent(GroupedTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType()));
                return;
            }
            TableModelEvent event = new TableModelEvent(GroupedTableModel.this, GroupedTableModel.this.mapFromModel(e.getFirstRow()), GroupedTableModel.this.mapFromModel(e.getLastRow()), e.getColumn(), e.getType());
            GroupedTableModel.this.fireTableModelEvent(event);
        }
    }
}

