/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingHeaderCellRenderer;

public class GroupingHeaderCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private GroupingHeaderCellRenderer renderer = new GroupingHeaderCellRenderer();
    private GroupingHeader header;

    public GroupingHeaderCellEditor() {
        this.renderer.setRequestFocusEnabled(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.header = (GroupingHeader)value;
        Component rendererComponent = this.renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        SwingUtilities.invokeLater(new AutoInvokeRunnable(this.header));
        return rendererComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.header;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    private class AutoInvokeRunnable
    implements Runnable {
        private GroupingHeader header;

        private AutoInvokeRunnable(GroupingHeader header) {
            this.header = header;
        }

        @Override
        public void run() {
            if (this.header != null) {
                this.header.setCollapsed(!this.header.isCollapsed());
                GroupingHeaderCellEditor.this.fireEditingStopped();
            }
        }
    }
}

