/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.StyleContext;
import org.pentaho.reporting.designer.core.util.table.GroupedTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;

public class GroupingHeaderCellRenderer
extends DefaultTableCellRenderer {
    private static final String EXPAND_ICON_LOCATION = "/org/pentaho/reporting/designer/core/icons/btn_plus.png";
    private static final String COLLAPSE_ICON_LOCATION = "/org/pentaho/reporting/designer/core/icons/btn_minus.png";
    private Icon expandImage;
    private Icon collapseImage;

    public GroupingHeaderCellRenderer() {
        URL expandIconUrl = GroupingHeaderCellRenderer.class.getResource(EXPAND_ICON_LOCATION);
        if (expandIconUrl == null) {
            throw new IllegalStateException("Icon-file was not found: /org/pentaho/reporting/designer/core/icons/btn_plus.png");
        }
        URL collapseIconUrl = GroupingHeaderCellRenderer.class.getResource(COLLAPSE_ICON_LOCATION);
        if (collapseIconUrl == null) {
            throw new IllegalStateException("Icon-file was not found: /org/pentaho/reporting/designer/core/icons/btn_minus.png");
        }
        this.expandImage = new ImageIcon(Toolkit.getDefaultToolkit().createImage(expandIconUrl));
        this.collapseImage = new ImageIcon(Toolkit.getDefaultToolkit().createImage(collapseIconUrl));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return label;
        }
        label.setBackground(Color.GRAY);
        label.setForeground(Color.WHITE);
        if (column >= 1) {
            label.setText("");
            label.setIcon(null);
        } else {
            Font font = StyleContext.getDefaultStyleContext().getFont(label.getFont().getName(), 1, label.getFont().getSize());
            label.setFont(font);
            GroupingHeader groupingHeader = (GroupingHeader)value;
            boolean isCollapsed = groupingHeader.isCollapsed();
            if (table.getModel() instanceof GroupedTableModel) {
                label.setIcon(isCollapsed ? this.expandImage : this.collapseImage);
            }
        }
        return label;
    }
}

