/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table.expressions;

import java.awt.Component;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorRegistry;

public class ReportPreProcessorListCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel rendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof ReportPreProcessorMetaData) {
            ReportPreProcessorMetaData metaData = (ReportPreProcessorMetaData)value;
            rendererComponent.setText(metaData.getDisplayName(Locale.getDefault()));
            rendererComponent.setToolTipText(metaData.getDeprecationMessage(Locale.getDefault()));
        } else if (value instanceof ReportPreProcessor) {
            String key = value.getClass().getName();
            if (ReportPreProcessorRegistry.getInstance().isReportPreProcessorRegistered(key)) {
                ReportPreProcessorMetaData metaData = ReportPreProcessorRegistry.getInstance().getReportPreProcessorMetaData(key);
                String displayName = metaData.getDisplayName(Locale.getDefault());
                rendererComponent.setText(Messages.getString("ReportPreProcessorCellEditor.EditingInstanceMessage", displayName));
                rendererComponent.setToolTipText(metaData.getDeprecationMessage(Locale.getDefault()));
            } else {
                rendererComponent.setText(Messages.getString("ReportPreProcessorCellEditor.EditingInstanceMessage", key));
                rendererComponent.setToolTipText(null);
            }
        } else {
            this.setText(" ");
        }
        return rendererComponent;
    }
}

