/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table.expressions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.ExpressionListCellRenderer;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.CellEditorUtility;
import org.pentaho.reporting.designer.core.util.table.expressions.ExpressionPropertiesDialog;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.ValuePassThroughCellEditor;

public class StructureFunctionCellEditor
implements TableCellEditor {
    private static final String POPUP_EDITOR = "popupEditor";
    private JPanel carrierPanel;
    private JComboBox expressionEditor;
    private EventListenerList eventListenerList = new EventListenerList();
    private ReportDesignerContext designerContext;
    private ReportDocumentContext renderContext;
    private DefaultDataAttributeContext dataAttributeContext = new DefaultDataAttributeContext();
    private boolean initialized;

    public StructureFunctionCellEditor() {
        EllipsisButton ellipsisButton = new EllipsisButton("...");
        ellipsisButton.addActionListener((ActionListener)new ExtendedEditorAction());
        this.expressionEditor = new SmartComboBox();
        this.expressionEditor.setEditable(false);
        this.expressionEditor.setEditor((ComboBoxEditor)new ValuePassThroughCellEditor(this.expressionEditor, (ListCellRenderer)new ExpressionListCellRenderer()));
        this.expressionEditor.setRenderer(new ExpressionListCellRenderer());
        this.expressionEditor.getInputMap().put(UtilMessages.getInstance().getKeyStroke("PropertyCellEditorWithEllipsis.PopupEditor.Accelerator"), POPUP_EDITOR);
        this.expressionEditor.getActionMap().put(POPUP_EDITOR, new ExtendedEditorAction());
        this.expressionEditor.setBorder(BorderFactory.createEmptyBorder());
        this.carrierPanel = new JPanel(new BorderLayout());
        this.carrierPanel.add((Component)this.expressionEditor, "Center");
        this.carrierPanel.add((Component)ellipsisButton, "East");
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        DefaultComboBoxModel<ExpressionMetaData> model = new DefaultComboBoxModel<ExpressionMetaData>();
        model.addElement(null);
        for (ExpressionMetaData expressionMetaData : ExpressionRegistry.getInstance().getAllExpressionMetaDatas()) {
            if (expressionMetaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)expressionMetaData) || !StructureFunction.class.isAssignableFrom(expressionMetaData.getExpressionType())) continue;
            model.addElement(expressionMetaData);
        }
        this.expressionEditor.setModel(model);
    }

    public void setRenderContext(ReportDocumentContext renderContext) {
        this.renderContext = renderContext;
    }

    public FieldDefinition[] getFields() {
        return CellEditorUtility.getFields(this.renderContext, new String[0]);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.init();
        StructureFunction value1 = value instanceof StructureFunction ? (StructureFunction)value : null;
        this.expressionEditor.setSelectedItem(value1);
        return this.carrierPanel;
    }

    @Override
    public Object getCellEditorValue() {
        Object o = this.expressionEditor.getSelectedItem();
        if (o instanceof ExpressionMetaData) {
            try {
                ExpressionMetaData emd = (ExpressionMetaData)o;
                if (StructureFunction.class.isAssignableFrom(emd.getExpressionType())) {
                    return emd.getExpressionType().newInstance();
                }
                return null;
            }
            catch (Throwable t) {
                UncaughtExceptionsModel.getInstance().addException(t);
                return null;
            }
        }
        if (o instanceof StructureFunction) {
            return o;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() >= 2 && mouseEvent.getButton() == 1;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.expressionEditor.actionPerformed(new ActionEvent(this, 0, ""));
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.designerContext = reportDesignerContext;
    }

    private class ExtendedEditorAction
    extends AbstractAction {
        private ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = LibSwingUtil.getWindowAncestor((Component)StructureFunctionCellEditor.this.carrierPanel);
            Object selectedItem = StructureFunctionCellEditor.this.expressionEditor.getSelectedItem();
            if (selectedItem instanceof StructureFunction) {
                StructureFunction structureFunction;
                ExpressionPropertiesDialog optionPane = window instanceof JFrame ? new ExpressionPropertiesDialog((JFrame)window) : (window instanceof JDialog ? new ExpressionPropertiesDialog((JDialog)window) : new ExpressionPropertiesDialog());
                StructureFunction expression = (StructureFunction)optionPane.editExpression((Expression)(structureFunction = (StructureFunction)selectedItem), StructureFunctionCellEditor.this.designerContext);
                if (expression != selectedItem) {
                    StructureFunctionCellEditor.this.expressionEditor.setSelectedItem(expression);
                }
                StructureFunctionCellEditor.this.fireEditingStopped();
            } else if (selectedItem instanceof ExpressionMetaData) {
                try {
                    ExpressionMetaData emd = (ExpressionMetaData)selectedItem;
                    Expression expression = (Expression)emd.getExpressionType().newInstance();
                    ExpressionPropertiesDialog optionPane = window instanceof JFrame ? new ExpressionPropertiesDialog((JFrame)window) : (window instanceof JDialog ? new ExpressionPropertiesDialog((JDialog)window) : new ExpressionPropertiesDialog());
                    Expression resultexpression = optionPane.editExpression(expression, StructureFunctionCellEditor.this.designerContext);
                    if (resultexpression != expression) {
                        StructureFunctionCellEditor.this.expressionEditor.setSelectedItem(resultexpression);
                    }
                    StructureFunctionCellEditor.this.fireEditingStopped();
                }
                catch (Throwable e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                }
            }
        }
    }
}

