/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class ExpressionAddedUndoEntry
implements UndoEntry {
    private int position;
    private Expression expression;

    public ExpressionAddedUndoEntry(int position, Expression expression) {
        this.position = position;
        this.expression = expression;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        AbstractReportDefinition definition = renderContext.getReportDefinition();
        definition.getExpressions().removeExpression(this.expression);
        definition.notifyNodeChildRemoved((Object)this.expression);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        AbstractReportDefinition definition = renderContext.getReportDefinition();
        if (!definition.getExpressions().contains(this.expression)) {
            definition.getExpressions().add(this.position, this.expression);
            definition.notifyNodeChildAdded((Object)this.expression);
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

