/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;

public class ExpressionPropertyChangeUndoEntry
implements UndoEntry {
    private Expression element;
    private Object oldPropertyValue;
    private Object newPropertyValue;
    private String name;

    public ExpressionPropertyChangeUndoEntry(Expression element, String name, Object oldPropertyValue, Object newPropertyValue) {
        this.element = element;
        this.name = name;
        this.oldPropertyValue = oldPropertyValue;
        this.newPropertyValue = newPropertyValue;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        try {
            BeanUtility bu = new BeanUtility((Object)this.element);
            bu.setProperty(this.name, this.oldPropertyValue);
            renderContext.getReportDefinition().fireModelLayoutChanged((ReportElement)renderContext.getReportDefinition(), 0, (Object)this.element);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        try {
            BeanUtility bu = new BeanUtility((Object)this.element);
            bu.setProperty(this.name, this.newPropertyValue);
            renderContext.getReportDefinition().fireModelLayoutChanged((ReportElement)renderContext.getReportDefinition(), 0, (Object)this.element);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        if (!(newEntry instanceof ExpressionPropertyChangeUndoEntry)) {
            return null;
        }
        ExpressionPropertyChangeUndoEntry entry = (ExpressionPropertyChangeUndoEntry)newEntry;
        if (entry.element == this.element) {
            return newEntry;
        }
        return null;
    }
}

