/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class ParameterEditUndoEntry
implements UndoEntry {
    private int position;
    private ParameterDefinitionEntry oldElement;
    private ParameterDefinitionEntry newElement;

    public ParameterEditUndoEntry(int position, ParameterDefinitionEntry oldElement, ParameterDefinitionEntry newElement) {
        this.position = position;
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        AbstractReportDefinition abstractReportDefinition = renderContext.getReportDefinition();
        if (!(abstractReportDefinition instanceof MasterReport)) {
            return;
        }
        MasterReport report = (MasterReport)abstractReportDefinition;
        ReportParameterDefinition definition = report.getParameterDefinition();
        if (!(definition instanceof ModifiableReportParameterDefinition)) {
            return;
        }
        ModifiableReportParameterDefinition mdef = (ModifiableReportParameterDefinition)definition;
        if (this.newElement != null) {
            mdef.removeParameterDefinition(this.position);
            this.clearParameterValues(report);
            report.notifyNodeChildRemoved((Object)this.newElement);
        }
        if (this.oldElement != null) {
            mdef.addParameterDefinition(this.position, this.oldElement);
            this.clearParameterValues(report);
            report.notifyNodeChildAdded((Object)this.oldElement);
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        AbstractReportDefinition abstractReportDefinition = renderContext.getReportDefinition();
        if (!(abstractReportDefinition instanceof MasterReport)) {
            return;
        }
        MasterReport report = (MasterReport)abstractReportDefinition;
        ReportParameterDefinition definition = report.getParameterDefinition();
        if (!(definition instanceof ModifiableReportParameterDefinition)) {
            return;
        }
        ModifiableReportParameterDefinition mdef = (ModifiableReportParameterDefinition)definition;
        if (this.oldElement != null) {
            mdef.removeParameterDefinition(this.position);
            this.clearParameterValues(report);
            report.notifyNodeChildRemoved((Object)this.oldElement);
        }
        if (this.newElement != null) {
            mdef.addParameterDefinition(this.position, this.newElement);
            this.clearParameterValues(report);
            report.notifyNodeChildAdded((Object)this.newElement);
        }
    }

    private void clearParameterValues(MasterReport report) {
        String[] columnNames = report.getParameterValues().getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            report.getParameterValues().put(columnName, null);
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

