/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.versionchecker;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.designer.core.versionchecker.Messages;
import org.pentaho.reporting.designer.core.versionchecker.UpdateInfo;
import org.pentaho.reporting.designer.core.versionchecker.UpdateTableModel;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class VersionConfirmationDialog
extends JDialog {
    private Action yesAction;
    private JTable updateList;
    private UpdateInfo[] updates;
    private boolean exitOnLaunch;

    public VersionConfirmationDialog(UpdateInfo[] updates, boolean exitOnLaunch) throws HeadlessException {
        this.init(updates, exitOnLaunch);
    }

    public VersionConfirmationDialog(Frame owner, UpdateInfo[] updates, boolean exitOnLaunch) throws HeadlessException {
        super(owner);
        this.init(updates, exitOnLaunch);
    }

    public VersionConfirmationDialog(Dialog owner, UpdateInfo[] updates, boolean exitOnLaunch) throws HeadlessException {
        super(owner);
        this.init(updates, exitOnLaunch);
    }

    private void init(UpdateInfo[] updates, boolean exitOnLaunch) {
        this.updates = (UpdateInfo[])updates.clone();
        this.exitOnLaunch = exitOnLaunch;
        this.setTitle(Messages.getInstance().getString("VersionConfirmationDialog.Title"));
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.updateList = new JTable(new UpdateTableModel(updates));
        this.updateList.addMouseListener(new MouseHandler());
        this.updateList.getSelectionModel().addListSelectionListener(new UpdateSelectionHandler());
        JScrollPane updateListScroller = new JScrollPane(this.updateList);
        updateListScroller.setPreferredSize(new Dimension(320, 120));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.getContentPane().add((Component)updateListScroller, c);
        c.insets = new Insets(0, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 10;
        c.fill = 2;
        this.getContentPane().add((Component)this.createButtons(), c);
        JComponent contentPane = (JComponent)this.getContentPane();
        InputMap inputMap = contentPane.getInputMap();
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("cancel", new IgnoreAction());
    }

    protected Action getYesAction() {
        return this.yesAction;
    }

    public boolean isSelectionActive() {
        return this.updateList.getSelectedRow() != -1;
    }

    public UpdateInfo[] getUpdates() {
        return (UpdateInfo[])this.updates.clone();
    }

    private JPanel createButtons() {
        this.yesAction = new UpdateAction();
        JButton yesButton = new JButton(this.yesAction);
        JButton noButton = new JButton(new IgnoreAction());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        buttonPanel.add((Component)yesButton, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        buttonPanel.add((Component)noButton, c);
        return buttonPanel;
    }

    protected void performLaunch() {
        try {
            int selectedRow = this.updateList.getSelectedRow();
            String url = this.updates[selectedRow].getUrl();
            ExternalToolLauncher.openURL(url);
            if (this.exitOnLaunch) {
                WorkspaceSettings.getInstance().flush();
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void performUpdateAvailable(Component parent, UpdateInfo[] updates, boolean exitOnLaunch) {
        Window window;
        VersionConfirmationDialog dialog = parent == null ? new VersionConfirmationDialog(updates, exitOnLaunch) : ((window = LibSwingUtil.getWindowAncestor((Component)parent)) instanceof Frame ? new VersionConfirmationDialog((Frame)window, updates, exitOnLaunch) : (window instanceof Dialog ? new VersionConfirmationDialog((Dialog)window, updates, exitOnLaunch) : new VersionConfirmationDialog(updates, exitOnLaunch)));
        dialog.pack();
        LibSwingUtil.centerFrameOnScreen((Window)dialog);
        dialog.setVisible(true);
    }

    private class IgnoreAction
    extends AbstractAction {
        private IgnoreAction() {
            this.putValue("Name", Messages.getInstance().getString("VersionConfirmationDialog.Ignore"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdateInfo[] updateInfos = VersionConfirmationDialog.this.getUpdates();
            if (updateInfos.length > 0) {
                WorkspaceSettings.getInstance().setLastPromptedVersionUpdate(updateInfos[updateInfos.length - 1].getVersion());
            }
            VersionConfirmationDialog.this.setVisible(false);
        }
    }

    private class UpdateSelectionHandler
    implements ListSelectionListener {
        private UpdateSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            VersionConfirmationDialog.this.getYesAction().setEnabled(VersionConfirmationDialog.this.isSelectionActive());
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private UpdateAction() {
            this.putValue("Name", Messages.getInstance().getString("VersionConfirmationDialog.Update"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VersionConfirmationDialog.this.performLaunch();
            VersionConfirmationDialog.this.setVisible(false);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && e.getButton() == 1 && VersionConfirmationDialog.this.isSelectionActive()) {
                VersionConfirmationDialog.this.performLaunch();
            }
        }
    }
}

