/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.welcome;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.global.OpenReportAction;

public class FilesTree
extends JTree {
    private ReportDesignerContext reportDesignerContext;
    private JDialog owner;

    public FilesTree(TreeModel treeModel, ReportDesignerContext reportDesignerContext, JDialog owner) {
        super(treeModel);
        this.reportDesignerContext = reportDesignerContext;
        this.owner = owner;
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseHandler());
        this.addKeyListener(new KeyboardHandler());
    }

    private void performDefaultAction() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            if (this.owner != null) {
                this.owner.setVisible(false);
            }
            OpenReportAction.openReport(new File(node.getUserObject().toString()), this.reportDesignerContext);
        }
    }

    private class KeyboardHandler
    extends KeyAdapter {
        private KeyboardHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                FilesTree.this.performDefaultAction();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && e.getButton() == 1) {
                FilesTree.this.performDefaultAction();
            }
        }
    }
}

