/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.config.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.xml.sax.EntityResolver;

public class SpringSecurityHibernateConfig {
    Document document;
    private static final String ROOT_ELEMENT = "beans";
    private static final String PASSWORD_ENCODER_CLASS_XPATH = "/beans/bean[@id=\"passwordEncoder\"]/@class";

    public SpringSecurityHibernateConfig(File xmlFile) throws IOException, DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromFile((File)xmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public SpringSecurityHibernateConfig(String xml) throws DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    public SpringSecurityHibernateConfig(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException(Messages.getInstance().getErrorString("PentahoXml.ERROR_0001_INVALID_ROOT_ELEMENT"));
        }
        this.document = doc;
    }

    public SpringSecurityHibernateConfig() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    public PasswordEncoder getPasswordEncoder() {
        try {
            String pentahoEncoderClassName = this.document.selectSingleNode(PASSWORD_ENCODER_CLASS_XPATH).getText();
            Class<?> passwordEncoderClass = Class.forName(pentahoEncoderClassName);
            return (PasswordEncoder)passwordEncoderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

