/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.osgi.PentahoOSGIActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIBoot
implements IPentahoSystemListener {
    private final PentahoOSGIActivator pentahoOSGIActivator = new PentahoOSGIActivator();
    Framework framework;
    private Logger logger = LoggerFactory.getLogger(OSGIBoot.class);

    public boolean startup(IPentahoSession session) {
        this.logger.info("Starting OSGI Environment");
        String solutionRootPath = PentahoSystem.getApplicationContext().getSolutionRootPath();
        String sep = File.separator;
        File log4jConf = new File(solutionRootPath + "/system/osgi/log4j.xml");
        System.setProperty("log4j.configuration", log4jConf.toURI().toString());
        System.setProperty("log4j.ignoreTCL", "true");
        Properties osgiProps = new Properties();
        File propsFile = new File(solutionRootPath + sep + "system" + sep + "osgi" + sep + "config.properties");
        if (propsFile.exists()) {
            try {
                osgiProps.load(new FileInputStream(propsFile));
            }
            catch (IOException e) {
                this.logger.error("Error reading OSGI Host config", (Throwable)e);
            }
        }
        HashMap<String, String> configProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : osgiProps.entrySet()) {
            configProps.put(entry.getKey().toString(), entry.getValue().toString());
        }
        configProps.put("org.osgi.framework.storage", solutionRootPath + "/system/osgi/cache");
        System.setProperty("felix.fileinstall.dir", solutionRootPath + "/system/osgi/bundles");
        configProps.put("felix.fileinstall.debug", "4");
        configProps.put("felix.fileinstall.bundles.new.start", "true");
        configProps.put("felix.fileinstall.bundles.startActivationPolicy", "false");
        configProps.put("org.eclipse.virgo.kernel.home", solutionRootPath + "/osgi/virgo");
        configProps.put("org.eclipse.virgo.kernel.config", solutionRootPath + "/osgi/virgo/configuration");
        configProps.put("osgi.sharedConfiguration.area", solutionRootPath + "/osgi/virgo/configuration");
        configProps.put("osgi.configuration.area", solutionRootPath + "/osgi/virgo/configuration");
        configProps.put("osgi.install.area", solutionRootPath + "/osgi/virgo");
        configProps.put("eclipse.ignoreApp", "true");
        try {
            this.logger.debug("Attempting to load OSGI FrameworkFactory.");
            FrameworkFactory factory = ServiceLoader.load(FrameworkFactory.class).iterator().next();
            this.logger.debug("FrameworkFactory found");
            this.framework = factory.newFramework(configProps);
            this.logger.debug("Initializing FrameworkFactory");
            this.framework.init();
            this.logger.debug("Starting FrameworkFactory");
            this.framework.start();
            Runtime.getRuntime().addShutdownHook(new Thread("Felix Shutdown Hook"){

                @Override
                public void run() {
                    OSGIBoot.this.shutdownFramework();
                }
            });
            ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
            File[] bundleDirectories = new File[]{new File(solutionRootPath + File.separator + "system" + File.separator + "osgi" + File.separator + "core_bundles"), new File(solutionRootPath + File.separator + "system" + File.separator + "osgi" + File.separator + "fragment_bundles"), new File(solutionRootPath + File.separator + "system" + File.separator + "osgi" + File.separator + "bundles")};
            this.logger.debug("Installing bundles");
            for (File bundleDirectory : bundleDirectories) {
                if (!bundleDirectory.exists()) {
                    this.logger.warn("Bundle directory: " + bundleDirectory.getName() + " does not exist");
                    continue;
                }
                Object[] files = bundleDirectory.listFiles();
                Arrays.sort(files);
                for (Object f : files) {
                    if (!((File)f).isFile() || !((File)f).getName().endsWith(".jar")) continue;
                    try {
                        Bundle b = this.framework.getBundleContext().installBundle(((File)f).toURI().toString());
                        bundleList.add(b);
                    }
                    catch (Exception e) {
                        this.logger.error("Error installing Bundle", (Throwable)e);
                    }
                }
            }
            this.logger.debug("Starting bundles");
            for (Bundle bundle : bundleList) {
                try {
                    if (bundle.getHeaders().get("Fragment-Host") != null) continue;
                    bundle.start();
                }
                catch (Exception e) {
                    this.logger.error("Error installing Bundle", (Throwable)e);
                }
            }
            this.pentahoOSGIActivator.setBundleContext(this.framework.getBundleContext());
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Error starting OSGI environment", (Throwable)ex);
            return false;
        }
    }

    private void shutdownFramework() {
        try {
            if (this.framework != null) {
                this.framework.stop();
                this.framework.waitForStop(0L);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error stopping OSGI", (Throwable)ex);
        }
    }

    public void shutdown() {
        this.pentahoOSGIActivator.shutdown();
        this.shutdownFramework();
    }
}

