/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIObjectFactory
implements IPentahoObjectFactory {
    private BundleContext context;
    Logger log = LoggerFactory.getLogger(OSGIObjectFactory.class);

    public OSGIObjectFactory(BundleContext context) {
        this.context = context;
    }

    public <T> T get(Class<T> tClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(tClass, null, session);
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        Map<String, String> map = key != null ? Collections.singletonMap("id", key) : Collections.emptyMap();
        return this.get(interfaceClass, session, map);
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        String filter = this.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            ServiceReference ref = refs != null && refs.size() > 0 ? refs.toArray(new ServiceReference[refs.size()])[0] : this.context.getServiceReference("" + interfaceClass.getName());
            if (ref == null) {
                this.log.error("\n\nOSGI: did not find object: " + interfaceClass.getName());
                return null;
            }
            Object obj = this.context.getService(ref);
            if (obj instanceof IPentahoInitializer) {
                ((IPentahoInitializer)obj).init(session);
            }
            return (T)obj;
        }
        catch (InvalidSyntaxException e) {
            this.log.error("Error retrieving from OSGI ObjectFactory", (Throwable)e);
            return null;
        }
    }

    public boolean objectDefined(String clazz) {
        if (clazz == null) {
            throw new IllegalStateException("Class is null");
        }
        ServiceReference ref = this.context.getServiceReference(clazz);
        return ref != null;
    }

    public boolean objectDefined(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalStateException("Class is null");
        }
        ServiceReference ref = this.context.getServiceReference(clazz);
        return ref != null;
    }

    public Class<?> getImplementingClass(String key) {
        throw new UnsupportedOperationException("OSGI Object Factory does not support this method");
    }

    public void init(String configFile, Object context) {
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getAll(interfaceClass, curSession, Collections.<String, String>emptyMap());
    }

    private String createFilter(Map<String, String> props) {
        if (props == null || props.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append("&(").append(entry.getKey()).append("=").append(entry.getValue()).append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        String filter = this.createFilter(properties);
        ArrayList<Object> returnList = new ArrayList<Object>();
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            if (refs == null || refs.size() == 0) {
                this.log.info("\n\nOSGI: did not find object: " + interfaceClass.getName());
                return returnList;
            }
            for (ServiceReference ref : refs) {
                Object obj = this.context.getService(ref);
                if (obj instanceof IPentahoInitializer) {
                    ((IPentahoInitializer)obj).init(session);
                }
                returnList.add(obj);
            }
            return returnList;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return returnList;
        }
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReference(interfaceClass, curSession, Collections.<String, String>emptyMap());
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        String filter = this.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            if (refs == null || refs.size() == 0) {
                this.log.error("\n\nOSGI: did not find object: " + interfaceClass.getName());
                return null;
            }
            ServiceReference serviceReference = refs.toArray(new ServiceReference[refs.size()])[0];
            return new OsgiPentahoObjectReference<T>(interfaceClass, serviceReference);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, Collections.<String, String>emptyMap());
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        String filter = this.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            if (refs == null || refs.size() == 0) {
                this.log.error("OSGI: did not find object: " + interfaceClass.getName());
                return Collections.emptyList();
            }
            ArrayList<IPentahoObjectReference<T>> returnRefs = new ArrayList<IPentahoObjectReference<T>>();
            for (ServiceReference ref : refs) {
                returnRefs.add(new OsgiPentahoObjectReference<T>(interfaceClass, ref));
            }
            Collections.sort(returnRefs);
            return returnRefs;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    private class OsgiPentahoObjectReference<T>
    implements IPentahoObjectReference<T> {
        private Class<T> type;
        private ServiceReference osgiRef;
        private Map<String, Object> attributes;

        public OsgiPentahoObjectReference(Class<T> type, ServiceReference ref) {
            this.type = type;
            this.osgiRef = ref;
        }

        public Class<?> getObjectClass() {
            return this.type;
        }

        public Map<String, Object> getAttributes() {
            if (this.attributes != null) {
                return this.attributes;
            }
            this.attributes = new HashMap<String, Object>();
            for (String key : this.osgiRef.getPropertyKeys()) {
                this.attributes.put(key, this.osgiRef.getProperty(key));
            }
            return this.attributes;
        }

        public T getObject() {
            Object service = OSGIObjectFactory.this.context.getService(this.osgiRef);
            if (service instanceof IPentahoInitializer) {
                ((IPentahoInitializer)service).init(PentahoSessionHolder.getSession());
            }
            return (T)service;
        }

        public Integer getRanking() {
            Object property = this.osgiRef.getProperty("service.ranking");
            if (!(property instanceof Integer)) {
                return 0;
            }
            return (Integer)property;
        }

        public int compareTo(IPentahoObjectReference<T> o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof OsgiPentahoObjectReference) {
                OsgiPentahoObjectReference ref = (OsgiPentahoObjectReference)o;
                return this.osgiRef.compareTo((Object)ref.osgiRef);
            }
            Integer ourRank = this.getRanking();
            Integer theirRanking = o.getRanking();
            return ourRank.compareTo(theirRanking);
        }
    }
}

