/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import org.osgi.framework.BundleContext;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.osgi.OSGIObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoOSGIActivator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private OSGIObjectFactory objectFactory;

    public void setBundleContext(BundleContext bundleContext) throws Exception {
        this.logger.debug("Registering OSGIObjectFactory");
        this.objectFactory = new OSGIObjectFactory(bundleContext);
        PentahoSystem.registerObjectFactory((IPentahoObjectFactory)this.objectFactory);
        this.logger.debug("OSGIObjectFactory installed");
    }

    public void shutdown() {
        if (this.objectFactory != null) {
            PentahoSystem.deregisterObjectFactory((IPentahoObjectFactory)this.objectFactory);
        }
    }
}

