/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.actionsequence.dom.actions.JFreeReportGenAction;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.jfreereport.castormodel.reportspec.Field;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpecChoice;
import org.pentaho.jfreereport.wizard.utility.report.ReportGenerationUtility;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class JFreeReportGeneratorComponent
extends ComponentBase {
    private static final long serialVersionUID = 9050456842938084174L;
    private static final String GROUP_LABELS_PROP = "group-labels";
    private static final String GROUP_LABEL_PROP = "group-label";
    private static final String GROUPED_COLUMNS_PROP = "grouped-columns";
    private static final String GROUPED_COLUMN_INDICES_PROP = "group-index";
    private static final String COLUMN_NAMES_PROP = "column-names";
    private static final String COLUMN_NAME_PROP = "column-name";
    private static final String COLUMN_WIDTHS_PROP = "column-widths";
    private static final String WIDTH_PROP = "width";
    private static final String COLUMN_ALIGNMENTS_PROP = "column-alignments";
    private static final String COLUMN_ALIGNMENT_PROP = "column-alignment";
    private static final String ITEM_HIDES_PROP = "item-hide-columns";
    private static final String ITEM_HIDE_PROP = "use-item-hide";
    private static final String COLUMN_FORMATS_PROP = "column-formats";
    private static final String FORMAT_PROP = "column-format";
    IPentahoResultSet resultSet = null;
    String[] displayNames = null;
    String compPath = null;
    String path = null;
    String orientation = "landscape";
    String[] groupLabels = null;
    int[] groupIndices = null;
    int[] widths = null;
    boolean[] itemHides = null;
    String[] formats = null;
    String[] columnAlignments;
    String reportName = "";
    boolean createSubTotals = false;
    boolean createGrandTotals = false;
    boolean createRowBanding = false;
    boolean createTotalColumn = false;
    String totalColumnName = "All";
    int totalColumnWidth = 120;
    String totalColumnFormat = "#,##0";
    String rowBandingColor = "#A0A0A0";
    int spacerWidth = 10;
    String columnHeaderBackgroundColor = "#C0C0C0";
    String columnHeaderForegroundColor = "#202020";
    String columnHeaderFontFace = "SansSerif";
    String columnHeaderFontSize = "12";
    int columnHeaderGap = 2;
    String nullString = "";
    int horizontalOffset = 0;

    public Log getLogger() {
        return LogFactory.getLog(JFreeReportGeneratorComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() {
        String reportDefinition;
        List formatNodes;
        List itemHideNodes;
        List widthNodes;
        List columnAlignmentNodes;
        List displayNameNodes;
        List groupedColumnsIndicesNodes;
        JFreeReportGenAction genAction = null;
        if (!(this.getActionDefinition() instanceof JFreeReportGenAction)) {
            this.error(Messages.getInstance().getErrorString("JFreeReportGeneratorComponent.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
            return false;
        }
        genAction = (JFreeReportGenAction)this.getActionDefinition();
        this.resultSet = (IPentahoResultSet)genAction.getResultSet().getValue();
        Node componentNode = null;
        String settingsFromActionSequence = null;
        try {
            settingsFromActionSequence = genAction.getComponentSettings().getStringValue();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (settingsFromActionSequence != null) {
            try {
                Document settingsDoc = XmlDom4JHelper.getDocFromString((String)settingsFromActionSequence, (EntityResolver)new PentahoEntityResolver());
                componentNode = settingsDoc.getRootElement();
            }
            catch (Exception e) {
                this.error("Could not get settings from action sequence document", e);
                return false;
            }
        } else {
            componentNode = this.getComponentDefinition();
        }
        try {
            this.compPath = genAction.getTemplatePath().getStringValue();
            this.path = PentahoSystem.getApplicationContext().getSolutionPath(this.compPath);
            this.orientation = genAction.getOrientation().getStringValue();
            this.nullString = genAction.getNullString().getStringValue();
            this.horizontalOffset = genAction.getHorizontalOffset().getIntValue(this.horizontalOffset);
            this.reportName = genAction.getReportName().getStringValue();
            this.createSubTotals = genAction.getCreateSubTotals().getBooleanValue(false);
            this.createGrandTotals = genAction.getCreateGrandTotals().getBooleanValue(false);
            this.createRowBanding = genAction.getCreateRowBanding().getBooleanValue(false);
            this.createTotalColumn = genAction.getCreateTotalColumn().getBooleanValue(false);
            this.totalColumnName = genAction.getTotalColumnName().getStringValue();
            this.totalColumnWidth = genAction.getTotalColumnWidth().getIntValue(this.totalColumnWidth);
            this.totalColumnFormat = genAction.getTotalColumnFormat().getStringValue();
            this.rowBandingColor = genAction.getRowBandingColor().getStringValue();
            this.spacerWidth = genAction.getSpacerWidth().getIntValue(this.spacerWidth);
            this.columnHeaderBackgroundColor = genAction.getColumnHeaderBackgroundColor().getStringValue();
            this.columnHeaderForegroundColor = genAction.getColumnHeaderForegroundColor().getStringValue();
            this.columnHeaderFontFace = genAction.getColumnHeaderFontFace().getStringValue();
            this.columnHeaderFontSize = genAction.getColumnHeaderFontSize().getStringValue();
            this.columnHeaderGap = genAction.getColumnHeaderGap().getIntValue(this.columnHeaderGap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List groupLabelNodes = componentNode.selectNodes("group-labels/group-label");
        if (groupLabelNodes != null) {
            this.groupLabels = new String[groupLabelNodes.size()];
            for (int i = 0; i < this.groupLabels.length; ++i) {
                this.groupLabels[i] = ((Node)groupLabelNodes.get(i)).getText();
            }
        }
        if ((groupedColumnsIndicesNodes = componentNode.selectNodes("grouped-columns/group-index")) != null) {
            this.groupIndices = new int[groupedColumnsIndicesNodes.size()];
            for (int i = 0; i < this.groupIndices.length; ++i) {
                this.groupIndices[i] = Integer.parseInt(((Node)groupedColumnsIndicesNodes.get(i)).getText()) - 1;
            }
        }
        if ((displayNameNodes = componentNode.selectNodes("column-names/column-name")) != null) {
            this.displayNames = new String[displayNameNodes.size()];
            for (int i = 0; i < this.displayNames.length; ++i) {
                this.displayNames[i] = ((Node)displayNameNodes.get(i)).getText();
            }
        }
        if ((columnAlignmentNodes = componentNode.selectNodes("column-alignments/column-alignment")) != null) {
            this.columnAlignments = new String[columnAlignmentNodes.size()];
            for (int i = 0; i < this.columnAlignments.length; ++i) {
                this.columnAlignments[i] = ((Node)columnAlignmentNodes.get(i)).getText();
            }
        }
        if ((widthNodes = componentNode.selectNodes("column-widths/width")) != null) {
            this.widths = new int[widthNodes.size()];
            for (int i = 0; i < this.widths.length; ++i) {
                this.widths[i] = Integer.valueOf(((Node)widthNodes.get(i)).getText());
            }
        }
        if ((itemHideNodes = componentNode.selectNodes("item-hide-columns/use-item-hide")) != null) {
            this.itemHides = new boolean[itemHideNodes.size()];
            for (int i = 0; i < this.itemHides.length; ++i) {
                this.itemHides[i] = Boolean.valueOf(((Node)itemHideNodes.get(i)).getText());
            }
        }
        if ((formatNodes = componentNode.selectNodes("column-formats/column-format")) != null) {
            this.formats = new String[formatNodes.size()];
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i] = ((Node)formatNodes.get(i)).getText();
            }
        }
        if ((reportDefinition = this.process()) != null) {
            if (genAction.getOutputReportDefinition() != null) {
                genAction.getOutputReportDefinition().setValue((Object)reportDefinition);
            } else {
                this.setOutputValue("report-definition", reportDefinition);
            }
        }
        return true;
    }

    public String process() {
        int i;
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
        }
        ReportSpec reportSpec = new ReportSpec();
        reportSpec.setReportName(this.reportName);
        reportSpec.setHorizontalOffset(this.horizontalOffset);
        reportSpec.setIncludeSrc(this.getPath());
        reportSpec.setQuery("no query");
        reportSpec.setReportSpecChoice(new ReportSpecChoice());
        reportSpec.getReportSpecChoice().setJndiSource("SampleData");
        reportSpec.setCalculateGrandTotals(this.createGrandTotals);
        reportSpec.setTopMargin(10);
        reportSpec.setBottomMargin(10);
        reportSpec.setLeftMargin(10);
        reportSpec.setRightMargin(10);
        reportSpec.setUseRowBanding(this.createRowBanding);
        reportSpec.setColumnHeaderGap(this.columnHeaderGap);
        if (this.rowBandingColor != null) {
            reportSpec.setRowBandingColor(this.rowBandingColor);
        }
        if (this.columnHeaderBackgroundColor != null) {
            reportSpec.setColumnHeaderBackgroundColor(this.columnHeaderBackgroundColor);
        }
        if (this.columnHeaderForegroundColor != null) {
            reportSpec.setColumnHeaderFontColor(this.columnHeaderForegroundColor);
        }
        if (this.columnHeaderFontFace != null) {
            reportSpec.setColumnHeaderFontName(this.columnHeaderFontFace);
        }
        if (this.columnHeaderFontSize != null) {
            reportSpec.setColumnHeaderFontSize(Integer.parseInt(this.columnHeaderFontSize));
        }
        reportSpec.setOrientation(this.orientation);
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        int totalWidth = reportSpec.getLeftMargin() + reportSpec.getRightMargin();
        LinkedList<Field> groupsList = new LinkedList<Field>();
        LinkedList<Field> details = new LinkedList<Field>();
        if (this.spacerWidth > 0) {
            Field spacer = new Field();
            spacer.setName("");
            spacer.setDisplayName("");
            spacer.setType(12);
            spacer.setFormat("");
            spacer.setHorizontalAlignment("right");
            spacer.setVerticalAlignment("middle");
            spacer.setWidth(new BigDecimal(this.spacerWidth));
            spacer.setWidthLocked(true);
            totalWidth += this.spacerWidth;
            spacer.setExpression("none");
            spacer.setIsWidthPercent(false);
            spacer.setIsDetail(true);
            reportSpec.addField(spacer);
        }
        for (i = 0; i < colHeaders.length; ++i) {
            Class<?> typeClass = null;
            for (int j = 0; j < this.resultSet.getRowCount(); ++j) {
                Object value = this.resultSet.getValueAt(j, i);
                if (value == null || value.toString().equals("")) continue;
                typeClass = value.getClass();
            }
            String columnName = colHeaders[i].toString();
            Field f = new Field();
            f.setName(columnName);
            f.setNullString(this.getNullString());
            if (this.isGroup(columnName)) {
                f.setDisplayName(this.getGroupLabel(columnName, i));
            } else if (i < this.displayNames.length) {
                f.setDisplayName(this.displayNames[i]);
            } else {
                f.setDisplayName(columnName);
            }
            f.setIsWidthPercent(false);
            f.setWidth(new BigDecimal(this.getWidth(columnName)));
            f.setWidthLocked(true);
            f.setIsDetail(!this.isGroup(columnName));
            if (f.getIsDetail()) {
                details.add(f);
            } else {
                groupsList.add(f);
            }
            f.setBackgroundColor("#FFFFFF");
            f.setType(this.getType(typeClass));
            if (this.itemHides == null || this.itemHides.length == 0) {
                f.setUseItemHide(this.getType(typeClass) != 2);
            } else {
                f.setUseItemHide(this.useItemHide(columnName));
            }
            f.setVerticalAlignment("middle");
            f.setFormat(this.getColumnFormat(columnName));
            String alignment = this.getColumnAlignment(columnName);
            if (alignment != null) {
                f.setHorizontalAlignment(alignment);
            } else if (f.getIsDetail() && f.getType() == 2) {
                f.setHorizontalAlignment("right");
            }
            if (f.getIsDetail() && f.getType() == 2) {
                f.setExpression("sum");
            } else {
                f.setExpression("none");
            }
            f.setCalculateGroupTotals(this.createSubTotals);
            reportSpec.addField(f);
            if (this.spacerWidth <= 0 || !f.getIsDetail()) continue;
            Field spacer = new Field();
            spacer.setName("");
            spacer.setDisplayName("");
            spacer.setType(12);
            spacer.setFormat("");
            spacer.setHorizontalAlignment("right");
            spacer.setVerticalAlignment("middle");
            spacer.setWidth(new BigDecimal(this.spacerWidth));
            spacer.setWidthLocked(true);
            totalWidth += this.spacerWidth;
            spacer.setExpression("none");
            spacer.setIsWidthPercent(false);
            spacer.setIsDetail(true);
            reportSpec.addField(spacer);
        }
        for (i = 0; i < details.size(); ++i) {
            Field f = (Field)details.get(i);
            totalWidth += f.getWidth().intValue();
        }
        if (this.createTotalColumn) {
            Field f = new Field();
            f.setName("TOTAL_COLUMN");
            f.setDisplayName(this.totalColumnName);
            f.setType(2);
            f.setFormat(this.totalColumnFormat);
            f.setHorizontalAlignment("right");
            f.setVerticalAlignment("middle");
            f.setWidth(new BigDecimal(this.totalColumnWidth));
            f.setWidthLocked(true);
            f.setExpression("sum");
            f.setIsWidthPercent(false);
            f.setIsDetail(true);
            reportSpec.addField(f);
            totalWidth += this.totalColumnWidth;
            if (this.spacerWidth > 0) {
                Field spacer = new Field();
                spacer.setName("");
                spacer.setDisplayName("");
                spacer.setType(12);
                spacer.setFormat("");
                spacer.setHorizontalAlignment("right");
                spacer.setVerticalAlignment("middle");
                spacer.setWidth(new BigDecimal(this.spacerWidth));
                spacer.setWidthLocked(true);
                totalWidth += this.spacerWidth;
                spacer.setExpression("none");
                spacer.setIsWidthPercent(false);
                spacer.setIsDetail(true);
                reportSpec.addField(spacer);
            }
        }
        try {
            reportSpec.setUseCustomPageFormat(true);
            int width = 612;
            int height = 792;
            if (this.orientation.equalsIgnoreCase("landscape")) {
                width = height;
                height = 612;
            }
            int scaledHeight = height * totalWidth / width;
            if (this.orientation.equalsIgnoreCase("landscape")) {
                reportSpec.setCustomPageFormatHeight(totalWidth);
                reportSpec.setCustomPageFormatWidth(scaledHeight);
                ReportGenerationUtility.createJFreeReportXML((ReportSpec)reportSpec, (OutputStream)outputStream, (int)scaledHeight, (int)totalWidth, (boolean)this.createTotalColumn, (String)this.totalColumnName, (int)this.totalColumnWidth, (int)this.spacerWidth);
            } else {
                reportSpec.setCustomPageFormatHeight(scaledHeight);
                reportSpec.setCustomPageFormatWidth(totalWidth);
                ReportGenerationUtility.createJFreeReportXML((ReportSpec)reportSpec, (OutputStream)outputStream, (int)totalWidth, (int)scaledHeight, (boolean)this.createTotalColumn, (String)this.totalColumnName, (int)this.totalColumnWidth, (int)this.spacerWidth);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new String(outputStream.toByteArray());
    }

    public int getType(Class typeClass) {
        if (typeClass != null) {
            if (typeClass.getName().equals(String.class.getName())) {
                return 12;
            }
            if (typeClass.getName().equals(BigDecimal.class.getName()) || typeClass.getName().equals(Integer.class.getName())) {
                return 2;
            }
            if (typeClass.getName().equals(Date.class.getName())) {
                return 91;
            }
        }
        return 12;
    }

    public String getGroupLabel(String columnName, int index) {
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        for (int i = 0; i < colHeaders.length; ++i) {
            if (!colHeaders[i].equals(columnName)) continue;
            for (int j = 0; j < this.getGroupIndices().length; ++j) {
                if (i != this.getGroupIndices()[j]) continue;
                return this.groupLabels[j];
            }
        }
        return this.displayNames[index];
    }

    public boolean isGroup(String columnName) {
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        for (int i = 0; i < colHeaders.length; ++i) {
            if (!colHeaders[i].equals(columnName)) continue;
            for (int j = 0; j < this.getGroupIndices().length; ++j) {
                if (i != this.getGroupIndices()[j]) continue;
                return true;
            }
        }
        return false;
    }

    public String getColumnAlignment(String columnName) {
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        for (int i = 0; i < colHeaders.length; ++i) {
            if (!colHeaders[i].equals(columnName)) continue;
            try {
                String alignment = this.getColumnAlignments()[this.getColumnAlignments().length - 1];
                alignment = this.getColumnAlignments()[i];
                return alignment;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean useItemHide(String columnName) {
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        for (int i = 0; i < colHeaders.length; ++i) {
            if (!colHeaders[i].equals(columnName)) continue;
            boolean itemHide = this.getItemHides()[this.getItemHides().length - 1];
            try {
                itemHide = this.getItemHides()[i];
            }
            catch (Exception e) {
                // empty catch block
            }
            return itemHide;
        }
        return false;
    }

    public int getWidth(String columnName) {
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        for (int i = 0; i < colHeaders.length; ++i) {
            if (!colHeaders[i].equals(columnName)) continue;
            int width = this.getWidths()[this.getWidths().length - 1];
            try {
                width = this.getWidths()[i];
            }
            catch (Exception e) {
                // empty catch block
            }
            return width;
        }
        return 0;
    }

    public String getColumnFormat(String columnName) {
        Object[] colHeaders = this.resultSet.getMetaData().getColumnHeaders()[0];
        for (int i = 0; i < colHeaders.length; ++i) {
            if (!colHeaders[i].equals(columnName)) continue;
            String format = "";
            try {
                format = this.getFormats()[this.getFormats().length - 1];
                format = this.getFormats()[i];
            }
            catch (Exception e) {
                // empty catch block
            }
            return format;
        }
        return "";
    }

    public String getResultOutputName() {
        Set outputs = this.getOutputNames();
        if (outputs == null || outputs.size() == 0) {
            this.error("NO OUPUT DEFINED");
            return null;
        }
        String outputName = (String)outputs.iterator().next();
        return outputName;
    }

    public boolean init() {
        return true;
    }

    public String[] getFormats() {
        return this.formats;
    }

    public void setFormats(String[] formats) {
        this.formats = formats;
    }

    public String[] getGroupLabels() {
        return this.groupLabels;
    }

    public void setGroups(String[] groupLabels) {
        this.groupLabels = groupLabels;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public void setWidths(int[] widths) {
        this.widths = widths;
    }

    public boolean[] getItemHides() {
        return this.itemHides;
    }

    public void setItemHides(boolean[] itemHides) {
        this.itemHides = itemHides;
    }

    public String[] getColumnAlignments() {
        return this.columnAlignments;
    }

    public void setColumnAlignments(String[] columnAlignments) {
        this.columnAlignments = columnAlignments;
    }

    public int[] getGroupIndices() {
        return this.groupIndices;
    }

    public void setGroupIndices(int[] groupIndices) {
        this.groupIndices = groupIndices;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }
}

