/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.catalog;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mondrian.i18n.LocalizingDynamicSchemaProcessor;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.agg.AggregationManager;
import mondrian.spi.DynamicSchemaProcessor;
import mondrian.util.ClassResolver;
import mondrian.xmla.DataSourcesConfig;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository2.unified.IAclNodeHelper;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.catalog.IAclAwareMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogComplementInfo;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.pentaho.platform.repository.solution.filebased.MondrianVfs;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryVfsFileObject;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrAclNodeHelper;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public class MondrianCatalogHelper
implements IAclAwareMondrianCatalogService {
    private static final Log logger = LogFactory.getLog(MondrianCatalogHelper.class);
    private String dataSourcesConfig;
    private boolean useSchemaNameAsCatalogName = true;
    private Map<String, MondrianCatalogComplementInfo> catalogComplementInfoMap;
    private final boolean useLegacyDbName;
    private IAclNodeHelper aclHelper;
    private MondrianCatalogRepositoryHelper catalogRepositoryHelper;
    public static final String MONDRIAN_DATASOURCE_FOLDER = "mondrian";
    public static String MONDRIAN_CATALOG_CACHE_REGION = "mondrian-catalog-cache";

    protected List<MondrianCatalog> getCatalogs(IPentahoSession pentahoSession) {
        Map catalogsMap = (Map)PentahoSystem.getCacheManager((IPentahoSession)pentahoSession).getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString());
        ArrayList<MondrianCatalog> catalogs = new ArrayList<MondrianCatalog>();
        for (Object o : catalogsMap.values()) {
            if (!(o instanceof MondrianCatalog)) continue;
            catalogs.add((MondrianCatalog)o);
        }
        Collections.sort(catalogs, new Comparator<MondrianCatalog>(){

            @Override
            public int compare(MondrianCatalog o1, MondrianCatalog o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        SetUniqueList uniqueCatalogs = SetUniqueList.decorate(catalogs);
        return uniqueCatalogs;
    }

    protected boolean catalogExists(MondrianCatalog catalog, IPentahoSession pentahoSession) {
        MondrianCatalog foundCatalog;
        if (catalog != null && (foundCatalog = this.getCatalogFromCache(catalog.getName(), pentahoSession)) != null) {
            String newDefinition;
            String newDataSourceInfo;
            String foundDataSourceInfo = this.cleanseDataSourceInfo(foundCatalog.getDataSourceInfo());
            if (!foundDataSourceInfo.equals(newDataSourceInfo = this.cleanseDataSourceInfo(catalog.getDataSourceInfo()))) {
                return false;
            }
            String foundDefinition = foundCatalog.getDefinition();
            if (this.definitionEquals(foundDefinition, newDefinition = catalog.getDefinition())) {
                return true;
            }
        }
        return false;
    }

    protected MondrianCatalog getCatalogFromCache(String context, IPentahoSession pentahoSession) {
        Map catalogs = (Map)PentahoSystem.getCacheManager((IPentahoSession)pentahoSession).getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString());
        return (MondrianCatalog)catalogs.get(context);
    }

    public static MondrianCatalogHelper getInstance() {
        return (MondrianCatalogHelper)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", null);
    }

    @Deprecated
    @VisibleForTesting
    public MondrianCatalogHelper(IAclNodeHelper aclHelper) {
        this();
        this.aclHelper = aclHelper;
    }

    public MondrianCatalogHelper() {
        this(false);
    }

    public MondrianCatalogHelper(boolean useLegacyDbName) {
        this.useLegacyDbName = useLegacyDbName;
        try {
            DefaultFileSystemManager dfsm = (DefaultFileSystemManager)VFS.getManager();
            dfsm.addProvider(MONDRIAN_DATASOURCE_FOLDER, (FileProvider)new MondrianVfs());
        }
        catch (FileSystemException e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected synchronized void init(IPentahoSession pentahoSession) {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        if (cacheMgr.cacheEnabled(MONDRIAN_CATALOG_CACHE_REGION) && cacheMgr.getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString()) != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"init");
        }
        this.loadCatalogsIntoCache(this.makeDataSources(), PentahoSessionHolder.getSession());
        AggregationManager.instance().getCacheControl(null, null).flushSchemaCache();
    }

    @Override
    public synchronized void reInit(IPentahoSession pentahoSession) {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        if (cacheMgr.cacheEnabled(MONDRIAN_CATALOG_CACHE_REGION)) {
            cacheMgr.clearRegionCache(MONDRIAN_CATALOG_CACHE_REGION);
        }
        this.init(pentahoSession);
    }

    private static Locale getLocale() {
        Locale locale = LocaleHelper.getLocale();
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    protected DataSourcesConfig.DataSources makeDataSources() {
        try {
            URL dataSourcesConfigUrl = null;
            if (this.dataSourcesConfig == null) {
                String datasourcesXML = this.generateInMemoryDatasourcesXml((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)PentahoSessionHolder.getSession()));
                return this.parseDataSources(datasourcesXML);
            }
            if (this.dataSourcesConfig.startsWith("file:")) {
                dataSourcesConfigUrl = new URL(this.dataSourcesConfig);
                return dataSourcesConfigUrl == null ? null : this.parseDataSourcesUrl(dataSourcesConfigUrl);
            }
            if (this.dataSourcesConfig.startsWith("classpath:")) {
                dataSourcesConfigUrl = this.getClass().getResource(this.dataSourcesConfig.substring(10));
                return dataSourcesConfigUrl == null ? null : this.parseDataSourcesUrl(dataSourcesConfigUrl);
            }
            throw new MondrianCatalogServiceException("dataSourcesConfig is not a valid URL or does not exist", MondrianCatalogServiceException.Reason.GENERAL);
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0001_INVALID_DATASOURCE_CONFIG", new Object[]{this.dataSourcesConfig}), e, MondrianCatalogServiceException.Reason.GENERAL);
        }
    }

    public String generateInMemoryDatasourcesXml(IUnifiedRepository unifiedRepository) {
        String etcMondrian = ClientRepositoryPaths.getEtcFolderPath() + "/" + MONDRIAN_DATASOURCE_FOLDER;
        RepositoryFile etcMondrianFolder = unifiedRepository.getFile(etcMondrian);
        if (etcMondrianFolder == null) {
            return null;
        }
        StringBuffer datasourcesXML = new StringBuffer();
        datasourcesXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        datasourcesXML.append("<DataSources>\n");
        datasourcesXML.append("<DataSource>\n");
        if (this.useLegacyDbName) {
            datasourcesXML.append("<DataSourceName>Provider=Mondrian</DataSourceName>\n");
        } else {
            datasourcesXML.append("<DataSourceName>Pentaho Mondrian</DataSourceName>\n");
        }
        datasourcesXML.append("<DataSourceDescription>Pentaho BI Platform Datasources</DataSourceDescription>\n");
        datasourcesXML.append("<URL>" + this.contextPathFromRequestContextHolder() + "Xmla</URL>\n");
        datasourcesXML.append("<DataSourceInfo>Provider=Mondrian</DataSourceInfo>\n");
        datasourcesXML.append("<ProviderName>PentahoXMLA</ProviderName>\n");
        datasourcesXML.append("<ProviderType>MDP</ProviderType>\n");
        datasourcesXML.append("<AuthenticationMode>Unauthenticated</AuthenticationMode>\n");
        this.appendCatalogsSection(unifiedRepository, etcMondrian, etcMondrianFolder, datasourcesXML);
        datasourcesXML.append("</DataSource>\n");
        datasourcesXML.append("</DataSources>\n");
        return datasourcesXML.toString();
    }

    @VisibleForTesting
    protected String contextPathFromRequestContextHolder() {
        return PentahoRequestContextHolder.getRequestContext().getContextPath();
    }

    @VisibleForTesting
    protected void appendCatalogsSection(IUnifiedRepository unifiedRepository, String etcMondrian, RepositoryFile etcMondrianFolder, StringBuffer datasourcesXML) {
        datasourcesXML.append("<Catalogs>\n");
        Encoder encoder = ESAPI.encoder();
        List mondrianCatalogs = unifiedRepository.getChildren(etcMondrianFolder.getId());
        for (RepositoryFile catalog : mondrianCatalogs) {
            String catalogName = catalog.getName();
            RepositoryFile metadata = unifiedRepository.getFile(etcMondrian + "/" + catalogName + "/" + "metadata");
            if (metadata != null) {
                DataNode metadataNode = ((NodeRepositoryFileData)unifiedRepository.getDataForRead(metadata.getId(), NodeRepositoryFileData.class)).getNode();
                String datasourceInfo = metadataNode.getProperty("datasourceInfo").getString();
                String definition = metadataNode.getProperty("definition").getString();
                datasourcesXML.append("<Catalog name=\"" + encoder.encodeForXML(catalogName) + "\">\n");
                datasourcesXML.append("<DataSourceInfo>" + encoder.encodeForXML(datasourceInfo) + "</DataSourceInfo>\n");
                datasourcesXML.append("<Definition>" + encoder.encodeForXML(definition) + "</Definition>\n");
                datasourcesXML.append("</Catalog>\n");
                continue;
            }
            logger.warn((Object)Messages.getInstance().getString("MondrianCatalogHelper.WARN_META_DATA_IS_NULL"));
        }
        datasourcesXML.append("</Catalogs>\n");
    }

    protected DataSourcesConfig.DataSources parseDataSourcesUrl(URL dataSourcesConfigUrl) {
        try {
            String dataSourcesConfigString = this.readDataSourcesContent(dataSourcesConfigUrl);
            return this.parseDataSources(dataSourcesConfigString);
        }
        catch (Exception e) {
            throw Util.newError((Throwable)e, (String)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0002_FAILED_TO_PARSE_DATASOURCE_CONFIG", new Object[]{dataSourcesConfigUrl.toExternalForm()}));
        }
    }

    protected String readDataSourcesContent(URL dataSourcesConfigUrl) throws IOException {
        return Util.readURL((URL)dataSourcesConfigUrl, (Map)Util.toMap((Properties)System.getProperties()));
    }

    protected DataSourcesConfig.DataSources parseDataSources(String dataSourcesConfigString) {
        try {
            if (dataSourcesConfigString == null) {
                logger.warn((Object)Messages.getInstance().getString("MondrianCatalogHelper.WARN_PARSE_NULL_INPUT"));
                return null;
            }
            String replacedConfigString = Util.replaceProperties((String)dataSourcesConfigString, (Map)Util.toMap((Properties)System.getProperties()));
            if (logger.isDebugEnabled()) {
                String msg = "parseDataSources: dataSources=" + replacedConfigString;
                logger.debug((Object)msg);
            }
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper doc = parser.parse(replacedConfigString);
            this.catalogComplementInfoMap = this.makeCatalogComplementInfoMap(doc);
            return new DataSourcesConfig.DataSources(doc);
        }
        catch (XOMException e) {
            throw Util.newError((Throwable)e, (String)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0002_FAILED_TO_PARSE_DATASOURCE_CONFIG", new Object[]{dataSourcesConfigString}));
        }
    }

    protected Map<String, MondrianCatalogComplementInfo> makeCatalogComplementInfoMap(DOMWrapper doc) {
        HashMap<String, MondrianCatalogComplementInfo> map = new HashMap<String, MondrianCatalogComplementInfo>();
        if (doc.getElementChildren().length > 0) {
            int i;
            DOMWrapper dataSource = doc.getElementChildren()[0];
            DOMWrapper catalogs = null;
            for (i = 0; i < dataSource.getElementChildren().length; ++i) {
                DOMWrapper element = dataSource.getElementChildren()[i];
                if (!element.getTagName().equals("Catalogs")) continue;
                catalogs = element;
                break;
            }
            for (i = 0; i < catalogs.getElementChildren().length; ++i) {
                DOMWrapper catalog = catalogs.getElementChildren()[i];
                if (!"Catalog".equals(catalog.getTagName())) continue;
                MondrianCatalogComplementInfo complementInfo = new MondrianCatalogComplementInfo();
                for (int j = 0; j < catalog.getElementChildren().length; ++j) {
                    DOMWrapper whereNode = catalog.getElementChildren()[j];
                    if (!"WhereCondition".equals(whereNode.getTagName())) continue;
                    complementInfo.addWhereCondition(whereNode.getAttribute("cube"), whereNode.getText());
                }
                map.put(this.getDOMWrapperElementText(catalog, "Definition"), complementInfo);
            }
        }
        return map;
    }

    private String getDOMWrapperElementText(DOMWrapper element, String name) {
        for (int i = 0; i < element.getElementChildren().length; ++i) {
            DOMWrapper child = element.getElementChildren()[i];
            if (!child.getTagName().equals(name)) continue;
            return child.getText();
        }
        return null;
    }

    protected Map<String, MondrianCatalog> makeCatalogMap(List<MondrianCatalog> cats) {
        HashMap<String, MondrianCatalog> map = new HashMap<String, MondrianCatalog>();
        for (MondrianCatalog catalog : cats) {
            map.put(catalog.getName(), catalog);
        }
        return map;
    }

    private boolean definitionEquals(String def1, String def2) {
        if (def1.equals(def2)) {
            return true;
        }
        String tmp = def1.startsWith("solution:/") ? "solution:" + def1.substring(10) : "solution:/" + def1.substring(9);
        return tmp.equals(def2);
    }

    protected String cleanseDataSourceInfo(String dataSourceInfo) {
        if (dataSourceInfo == null) {
            return null;
        }
        Util.PropertyList propertyList = Util.parseConnectString((String)dataSourceInfo);
        if (propertyList.get("EnableXmla") != null) {
            propertyList.remove("EnableXmla");
        }
        if (propertyList.get("overwrite") != null) {
            propertyList.remove("overwrite");
        }
        return propertyList.toString();
    }

    public String getDataSourcesConfig() {
        return this.dataSourcesConfig;
    }

    public void setDataSourcesConfig(String dataSourcesConfig) {
        this.dataSourcesConfig = dataSourcesConfig;
    }

    @Override
    public List<MondrianCatalog> listCatalogs(IPentahoSession pentahoSession, boolean jndiOnly) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"listCatalogs");
        }
        this.init(pentahoSession);
        return Collections.unmodifiableList(this.filter(this.getCatalogs(pentahoSession), pentahoSession, jndiOnly));
    }

    @Override
    public synchronized void addCatalog(MondrianCatalog catalog, boolean overwrite, IPentahoSession pentahoSession) throws MondrianCatalogServiceException {
        String mondrianSchema = (String)pentahoSession.getAttribute("MONDRIAN_SCHEMA_XML_CONTENT");
        InputStream schemaInputStream = IOUtils.toInputStream((String)mondrianSchema);
        this.addCatalog(schemaInputStream, catalog, overwrite, pentahoSession);
    }

    @Override
    public void addCatalog(InputStream inputStream, MondrianCatalog catalog, boolean overwriteInRepossitory, IPentahoSession session) {
        this.addCatalog(inputStream, catalog, overwriteInRepossitory, null, session);
    }

    @Override
    public synchronized void addCatalog(InputStream schemaInputStream, MondrianCatalog catalog, boolean overwrite, RepositoryFileAcl acl, IPentahoSession pentahoSession) throws MondrianCatalogServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"addCatalog");
        }
        this.init(pentahoSession);
        if (this.catalogExists(catalog, pentahoSession) && !overwrite) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0004_ALREADY_EXISTS"), MondrianCatalogServiceException.Reason.ALREADY_EXISTS);
        }
        MondrianCatalog fileLocationCatalogTest = null;
        for (MondrianCatalog currentCatalogCheck : this.getCatalogs(pentahoSession)) {
            if (!currentCatalogCheck.getName().equals(catalog.getName())) continue;
            fileLocationCatalogTest = currentCatalogCheck;
            break;
        }
        if (fileLocationCatalogTest != null && this.definitionEquals(fileLocationCatalogTest.getDefinition(), "mondrian:/" + catalog.getName()) && !overwrite) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0004_ALREADY_EXISTS"), MondrianCatalogServiceException.Reason.XMLA_SCHEMA_NAME_EXISTS);
        }
        try {
            MondrianCatalogRepositoryHelper helper = this.getMondrianCatalogRepositoryHelper();
            helper.addHostedCatalog(schemaInputStream, catalog.getName(), catalog.getDataSourceInfo());
        }
        catch (Exception e) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0008_ERROR_OCCURRED"), MondrianCatalogServiceException.Reason.valueOf(e.getMessage()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refreshing from dataSourcesConfig (" + this.dataSourcesConfig + ")"));
        }
        this.reInit(pentahoSession);
        this.setAclFor(catalog.getName(), acl);
    }

    protected IUnifiedRepository getRepository() {
        return (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
    }

    protected synchronized MondrianCatalogRepositoryHelper getMondrianCatalogRepositoryHelper() {
        if (this.catalogRepositoryHelper == null) {
            this.catalogRepositoryHelper = new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
        }
        return this.catalogRepositoryHelper;
    }

    protected synchronized IAclNodeHelper getAclHelper() {
        if (this.aclHelper == null) {
            this.aclHelper = new JcrAclNodeHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
        }
        return this.aclHelper;
    }

    @Override
    public void setAclFor(String catalogName, RepositoryFileAcl acl) {
        this.getAclHelper().setAclFor(this.getMondrianCatalogRepositoryHelper().getMondrianCatalogFile(catalogName), acl);
    }

    @Override
    public RepositoryFileAcl getAclFor(String catalogName) {
        return this.getAclHelper().getAclFor(this.getMondrianCatalogRepositoryHelper().getMondrianCatalogFile(catalogName));
    }

    public void importSchema(File mondrianFile, String databaseConnection, String parameters) {
        try {
            String datasourceInfo = "Provider=mondrian;DataSource=" + databaseConnection;
            if (!StringUtils.isEmpty((String)parameters)) {
                datasourceInfo = parameters;
            }
            FileInputStream parsingInputStream = new FileInputStream(mondrianFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(parsingInputStream);
            NodeList schemas = document.getElementsByTagName("Schema");
            Node schema = schemas.item(0);
            if (schema == null) {
                throw new SAXParseException("", null);
            }
            Node name = schema.getAttributes().getNamedItem("name");
            String catalogName = name.getTextContent();
            parsingInputStream.close();
            FileInputStream schemaInputStream = new FileInputStream(mondrianFile);
            MondrianCatalogRepositoryHelper helper = new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
            helper.addSchema(schemaInputStream, catalogName, datasourceInfo);
            this.reInit(PentahoSessionHolder.getSession());
        }
        catch (SAXParseException e) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getString("MondrianCatalogHelper.ERROR_0018_IMPORT_SCHEMA_ERROR"));
        }
        catch (Exception e) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getString("MondrianCatalogHelper.ERROR_0008_ERROR_OCCURRED"), MondrianCatalogServiceException.Reason.valueOf(e.getMessage()));
        }
    }

    @Deprecated
    protected void writeDataSources(DataSourcesConfig.DataSources dataSources) {
        FileWriter sxml;
        File dataSourcesFile;
        try {
            dataSourcesFile = new File(new URL(this.dataSourcesConfig).getFile());
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0005_RESOURCE_NOT_AVAILABLE"), e, MondrianCatalogServiceException.Reason.GENERAL);
        }
        try {
            sxml = new FileWriter(dataSourcesFile);
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(e);
        }
        StringWriter sw = new StringWriter();
        XMLOutput pxml = new XMLOutput((Writer)sw);
        pxml.print("<?xml version=\"1.0\"?>\n");
        dataSources.displayXML(pxml, 0);
        Document doc = null;
        try {
            doc = XmlDom4JHelper.getDocFromString((String)sw.toString(), (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            throw new MondrianCatalogServiceException(e);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(doc.getXMLEncoding());
            XMLWriter writer = new XMLWriter((Writer)sxml, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            throw new MondrianCatalogServiceException(e);
        }
        IOUtils.closeQuietly((Writer)sxml);
    }

    @Override
    public MondrianCatalog getCatalog(String context, IPentahoSession pentahoSession) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getCatalog");
        }
        this.init(pentahoSession);
        MondrianCatalog cat = this.getCatalogFromCache(context, pentahoSession);
        if (null != cat) {
            if (this.hasAccess(cat, RepositoryFilePermission.READ)) {
                return cat;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("user requested catalog with name \"" + context + "\", but had insufficient privileges; returning null"));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("user requested catalog with name\"" + context + "\", but catalog doesn't exist"));
        }
        return null;
    }

    protected void loadCatalogsIntoCache(DataSourcesConfig.DataSources dataSources, IPentahoSession pentahoSession) {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        if (!cacheMgr.cacheEnabled(MONDRIAN_CATALOG_CACHE_REGION)) {
            cacheMgr.addCacheRegion(MONDRIAN_CATALOG_CACHE_REGION);
        }
        if (cacheMgr.getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString()) == null) {
            cacheMgr.putInRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString(), new HashMap());
        }
        for (DataSourcesConfig.DataSource dataSource : dataSources.dataSources) {
            ArrayList<String> catalogNames = new ArrayList<String>();
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                catalogNames.add(catalog.name);
            }
            Map catalogs = (Map)cacheMgr.getFromRegionCache(MONDRIAN_CATALOG_CACHE_REGION, (Object)MondrianCatalogHelper.getLocale().toString());
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                if (catalog.definition.startsWith("mondrian:") || catalog.definition.startsWith("solution:")) {
                    MondrianSchema schema = null;
                    try {
                        schema = this.makeSchema(this.getCatalogAsString(pentahoSession, catalog));
                    }
                    catch (Exception e) {
                        logger.error((Object)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0013_FAILED_TO_LOAD_SCHEMA", new Object[]{catalog.definition}), (Throwable)e);
                    }
                    MondrianCatalog mondrianCatalog = null;
                    mondrianCatalog = schema == null ? new MondrianCatalog(catalog.name, catalog.dataSourceInfo, catalog.definition, schema) : new MondrianCatalog(this.useSchemaNameAsCatalogName ? schema.getName() : catalog.name, catalog.dataSourceInfo, catalog.definition, schema);
                    catalogs.put(mondrianCatalog.getName(), mondrianCatalog);
                    catalogs.put(mondrianCatalog.getDefinition(), mondrianCatalog);
                    continue;
                }
                logger.warn((Object)Messages.getInstance().getString("MondrianCatalogHelper.WARN_SKIPPING_DATASOURCE_DEF", new Object[]{catalog.definition}));
            }
        }
    }

    protected String applyDSP(IPentahoSession ps, String catalogDsInfo, String catalogDefinition) throws Exception {
        Util.PropertyList pl = Util.parseConnectString((String)catalogDsInfo);
        String dsp = pl.get(RolapConnectionProperties.DynamicSchemaProcessor.name());
        if (dsp != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("applyDSP: " + dsp));
            }
            DynamicSchemaProcessor dynProc = (DynamicSchemaProcessor)ClassResolver.INSTANCE.instantiateSafe(dsp, new Object[0]);
            pl.put("Locale", MondrianCatalogHelper.getLocale().toString());
            return dynProc.processSchema(catalogDefinition, pl);
        }
        return this.docAtUrlToString(catalogDefinition, ps);
    }

    protected String getCatalogAsString(IPentahoSession ps, DataSourcesConfig.Catalog catalog) throws Exception {
        if (catalog.dataSourceInfo != null) {
            return this.applyDSP(ps, catalog.dataSourceInfo, catalog.definition);
        }
        logger.warn((Object)Messages.getInstance().getString("MondrianCatalogHelper.WARN_NO_CATALOG_DATASOURCE_INFO", new Object[]{catalog.name}));
        return this.docAtUrlToString(catalog.definition, ps);
    }

    @Deprecated
    protected List<MondrianCatalog> transformIntoCatalogList(DataSourcesConfig.DataSources dataSources, IPentahoSession pentahoSession) {
        ArrayList<MondrianCatalog> localCatalogs = new ArrayList<MondrianCatalog>();
        for (DataSourcesConfig.DataSource dataSource : dataSources.dataSources) {
            ArrayList<String> catalogNames = new ArrayList<String>();
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                catalogNames.add(catalog.name);
            }
            for (DataSourcesConfig.Catalog catalog : dataSource.catalogs.catalogs) {
                if (catalog.definition.startsWith("solution:")) {
                    try {
                        MondrianSchema schema = this.makeSchema(this.docAtUrlToString(catalog.definition, pentahoSession));
                        MondrianCatalogComplementInfo catalogComplementInfo = this.getCatalogComplementInfoMap(catalog.definition);
                        MondrianCatalog mondrianCatalog = new MondrianCatalog(this.useSchemaNameAsCatalogName ? schema.getName() : catalog.name, catalog.dataSourceInfo, catalog.definition, schema, catalogComplementInfo);
                        localCatalogs.add(mondrianCatalog);
                    }
                    catch (Exception e) {
                        logger.error((Object)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0013_FAILED_TO_LOAD_SCHEMA", new Object[]{catalog.definition}), (Throwable)e);
                    }
                    continue;
                }
                logger.warn((Object)Messages.getInstance().getString("MondrianCatalogHelper.WARN_SKIPPING_DATASOURCE_DEF", new Object[]{catalog.definition}));
            }
        }
        return localCatalogs;
    }

    public MondrianCatalogComplementInfo getCatalogComplementInfoMap(String name) {
        return this.catalogComplementInfoMap.get(name);
    }

    @Override
    public MondrianSchema loadMondrianSchema(String solutionLocation, IPentahoSession pentahoSession) {
        return this.makeSchema(this.docAtUrlToString(solutionLocation, pentahoSession));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String docAtUrlToString(String urlStr, IPentahoSession pentahoSession) {
        String res = null;
        InputStream in = null;
        try {
            LocalizingDynamicSchemaProcessor schemaProcessor = new LocalizingDynamicSchemaProcessor();
            Util.PropertyList localeInfo = new Util.PropertyList();
            localeInfo.put("Locale", MondrianCatalogHelper.getLocale().toString());
            FileSystemManager fsManager = VFS.getManager();
            SolutionRepositoryVfsFileObject mondrianDS = (SolutionRepositoryVfsFileObject)fsManager.resolveFile(urlStr);
            in = mondrianDS.getInputStream();
            res = schemaProcessor.filter(null, localeInfo, in);
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0007_FILE_NOT_FOUND"), fnfe);
                catch (Exception e) {
                    throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0006_IO_PROBLEM"), e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return res;
    }

    protected MondrianSchema getSchema(String catalogName, IPentahoSession pentahoSession) {
        MondrianCatalog catalog = this.getCatalogFromCache(catalogName, pentahoSession);
        if (null == catalog) {
            return null;
        }
        return catalog.getSchema();
    }

    protected MondrianSchema makeSchema(String catalogStr) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("makeSchema (catalogStr=" + catalogStr.substring(0, Math.min(40, catalogStr.length())) + "...)"));
        }
        MondrianSchema schema = null;
        try {
            String name;
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(catalogStr);
            MondrianDef.Schema schemaFromXml = new MondrianDef.Schema(def);
            String schemaName = schemaFromXml.name;
            ArrayList<MondrianCube> mondrianCubes = new ArrayList<MondrianCube>();
            for (MondrianDef.Cube cube : schemaFromXml.cubes) {
                if (cube.enabled != null && !cube.enabled.booleanValue()) continue;
                name = cube.caption;
                if (StringUtils.isBlank((String)name)) {
                    name = cube.name;
                }
                mondrianCubes.add(new MondrianCube(name, cube.name));
            }
            for (MondrianDef.Cube cube : schemaFromXml.virtualCubes) {
                name = cube.caption;
                if (StringUtils.isBlank((String)name)) {
                    name = cube.name;
                }
                if (cube.enabled != null && !cube.enabled.booleanValue()) continue;
                mondrianCubes.add(new MondrianCube(name, cube.name));
            }
            MondrianDef.Role[] roles = schemaFromXml.roles;
            String[] roleNames = null;
            if (roles != null && roles.length > 0) {
                roleNames = new String[roles.length];
                for (int i = 0; i < roles.length; ++i) {
                    roleNames[i] = roles[i].name;
                }
            }
            schema = new MondrianSchema(schemaName, mondrianCubes, roleNames);
        }
        catch (XOMException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0008_ERROR_OCCURRED"), (Throwable)e);
            }
            throw Util.newError((Throwable)e, (String)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0009_WHILE_PARSING_CATALOG", new Object[]{catalogStr}));
        }
        return schema;
    }

    protected List<MondrianCatalog> filter(List<MondrianCatalog> origList, IPentahoSession pentahoSession, boolean jndiOnly) {
        ArrayList<MondrianCatalog> filtered = new ArrayList<MondrianCatalog>();
        for (MondrianCatalog orig : origList) {
            if (!this.hasAccess(orig, RepositoryFilePermission.READ) || jndiOnly && !orig.isJndi()) continue;
            filtered.add(orig);
        }
        return filtered;
    }

    protected boolean hasAccess(MondrianCatalog cat, RepositoryFilePermission permission) {
        return this.getAclHelper().canAccess(this.getMondrianCatalogRepositoryHelper().getMondrianCatalogFile(cat.getName()), EnumSet.of(permission));
    }

    protected String getSolutionRepositoryRelativePath(String path, IPentahoSession pentahoSession) {
        try {
            FileSystemManager fsManager = VFS.getManager();
            return fsManager.resolveFile(path).getName().getPath();
        }
        catch (FileSystemException e) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0012_FILESYSTEM_PROBLEM"), e);
        }
    }

    public boolean isUseSchemaNameAsCatalogName() {
        return this.useSchemaNameAsCatalogName;
    }

    public void setUseSchemaNameAsCatalogName(boolean useSchemaNameAsCatalogName) {
        this.useSchemaNameAsCatalogName = useSchemaNameAsCatalogName;
    }

    public static int addToCatalog(String baseUrl, boolean enableXmla, String schemaSolutionPath, IPentahoSession session, String jndiName, boolean overwrite) {
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)session);
        String dsUrl = baseUrl;
        if (!dsUrl.endsWith("/")) {
            dsUrl = dsUrl + "/";
        }
        dsUrl = dsUrl + "Xmla";
        String catDef = "solution:" + schemaSolutionPath;
        MondrianSchema mondrianSchema = mondrianCatalogService.loadMondrianSchema(catDef, session);
        String catName = mondrianSchema.getName();
        String[] roleNames = mondrianSchema.getRoleNames();
        try {
            IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
            datasourceService.getDSBoundName(jndiName);
        }
        catch (ObjectFactoryException objface) {
            Logger.error((String)"MondrianCatalogHelper", (String)Messages.getInstance().getErrorString("MondrianCatalogPublisher.ERROR_0006_UNABLE_TO_FACTORY_OBJECT", new Object[]{jndiName}), (Throwable)objface);
        }
        catch (DBDatasourceServiceException dse) {
            Logger.error((String)"MondrianCatalogHelper", (String)Messages.getInstance().getErrorString("MondrianCatalogPublisher.ERROR_0001_JNDI_NAMING_ERROR", new Object[]{jndiName}), (Throwable)dse);
            return -1;
        }
        String catConnectStr = "Provider=mondrian;DataSource=" + jndiName;
        MondrianCatalog cat = new MondrianCatalog(catName, catConnectStr, catDef, new MondrianSchema(catName, new ArrayList<MondrianCube>(), roleNames));
        try {
            mondrianCatalogService.addCatalog(cat, overwrite, session);
        }
        catch (MondrianCatalogServiceException e) {
            Logger.error((String)"MondrianCatalogHelper", (String)Messages.getInstance().getErrorString("MondrianCatalogPublisher.ERROR_0002_EXCEPTION_OCCURRED"), (Throwable)e);
            return -1;
        }
        return 0;
    }

    @Override
    public void removeCatalog(String catalogName, IPentahoSession pentahoSession) throws MondrianCatalogServiceException {
        MondrianCatalog catalog;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeCatalog");
        }
        if ((catalog = this.getCatalog(catalogName, pentahoSession)) == null) {
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0015_CATALOG_NOT_FOUND", new Object[]{catalogName}));
        }
        if (!this.hasAccess(catalog, RepositoryFilePermission.WRITE)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"user does not have access; throwing exception");
            }
            throw new MondrianCatalogServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0003_INSUFFICIENT_PERMISSION"), MondrianCatalogServiceException.Reason.ACCESS_DENIED);
        }
        this.getAclHelper().removeAclFor(this.getMondrianCatalogRepositoryHelper().getMondrianCatalogFile(catalog.getName()));
        IUnifiedRepository solutionRepository = this.getRepository();
        RepositoryFile deletingFile = solutionRepository.getFile("/etc/mondrian/" + catalog.getName());
        solutionRepository.deleteFile(deletingFile.getId(), true, "");
        this.reInit(pentahoSession);
    }

    protected static enum CatalogPermission {
        READ,
        WRITE;

    }
}

