/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.hql;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;
import org.pentaho.commons.connection.ILimitableConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.engine.core.system.IPentahoLoggingConnection;
import org.pentaho.platform.plugin.services.connections.hql.HQLResultSet;
import org.pentaho.platform.plugin.services.messages.Messages;

public class HQLConnection
implements IPentahoLoggingConnection,
ILimitableConnection {
    protected String lastQuery = null;
    protected ILogger logger = null;
    IPentahoResultSet resultSet = null;
    File hibernateConfigFile = null;
    private int timeOut = -1;
    private int maxRows = -1;
    Configuration hibernateConfig = null;

    public void setConfigFile(File hbmCfg) {
        this.hibernateConfigFile = hbmCfg;
        this.hibernateConfig = new Configuration();
        this.hibernateConfig.configure(this.hibernateConfigFile);
    }

    public void setClassNames(String[] classNames) {
        for (int i = 0; classNames != null && i < classNames.length; ++i) {
            try {
                this.hibernateConfig.addClass(Class.forName(classNames[i]));
                continue;
            }
            catch (ClassNotFoundException e) {
                this.logger.error(null, (Throwable)e);
            }
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void setProperties(Properties props) {
    }

    public boolean initialized() {
        return true;
    }

    public String getDatasourceType() {
        return "HQL";
    }

    public IPentahoResultSet prepareAndExecuteQuery(String query, List parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean preparedQueriesSupported() {
        return false;
    }

    public void close() {
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet executeQuery(String query) {
        this.lastQuery = query;
        Session sess = null;
        IPentahoResultSet localResultSet = null;
        try {
            SessionFactory sf = this.hibernateConfig.buildSessionFactory();
            sess = sf.openSession();
            Query q = sess.createQuery(query);
            if (this.timeOut >= 0) {
                q.setTimeout(this.timeOut);
            }
            if (this.maxRows >= 0) {
                q.setMaxResults(this.maxRows);
            }
            List list = q.list();
            localResultSet = this.generateResultSet(list, q.getReturnAliases(), q.getReturnTypes());
        }
        finally {
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Exception e) {
                this.logger.error(Messages.getInstance().getErrorString("HQLConnection.ERROR_0001_UNABLE_TO_CLOSE"), (Throwable)e);
            }
        }
        return localResultSet;
    }

    public IPentahoResultSet generateResultSet(List list, String[] columnHeaders, Type[] columnTypes) {
        HQLResultSet localResultSet = new HQLResultSet(list, columnHeaders, columnTypes);
        return localResultSet;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void clearWarnings() {
    }

    public IPentahoResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean connect(Properties props) {
        return true;
    }

    public void setMaxRows(int value) {
        this.maxRows = value;
    }

    public void setFetchSize(int fetchSize) {
    }

    public void setQueryTimeout(int value) {
        this.timeOut = value;
    }
}

