/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.tinytree.TinyNodeImpl;
import org.pentaho.commons.connection.AbstractPentahoMetaData;
import org.pentaho.platform.plugin.services.connections.xquery.XQConnection;

public class XQMetaData
extends AbstractPentahoMetaData {
    public static final String DEFAULT_COLUMN_NAME = "Default Column";
    private Object[][] columnHeaders;
    private Object[][] rowHeaders;
    private XQConnection connection;
    int rowCount = 0;

    public XQMetaData(XQConnection xqConnection, Iterator iter) {
        this.connection = xqConnection;
        ArrayList<String> headers = new ArrayList<String>();
        while (iter.hasNext()) {
            String value;
            ++this.rowCount;
            Object obj = iter.next();
            if (!(obj instanceof TinyNodeImpl)) continue;
            boolean processedChildren = false;
            AxisIterator aIter = ((TinyNodeImpl)obj).iterateAxis((byte)4);
            Item descendent = aIter.next();
            while (descendent != null) {
                if (descendent instanceof TinyNodeImpl && ((TinyNodeImpl)descendent).getNodeKind() == 1) {
                    TinyNodeImpl descNode = (TinyNodeImpl)descendent;
                    processedChildren = true;
                    if (!headers.contains(descNode.getDisplayName())) {
                        headers.add(descNode.getDisplayName());
                    }
                }
                descendent = aIter.next();
            }
            if (processedChildren || headers.contains(value = ((TinyNodeImpl)obj).getDisplayName())) continue;
            headers.add(value);
        }
        if (headers.size() > 0) {
            this.columnHeaders = new Object[1][headers.size()];
            Iterator headerIter = headers.iterator();
            int i = 0;
            while (headerIter.hasNext()) {
                this.columnHeaders[0][i] = headerIter.next();
                ++i;
            }
        } else {
            this.columnHeaders = new Object[1][1];
            this.columnHeaders[0][0] = DEFAULT_COLUMN_NAME;
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object[][] getColumnHeaders() {
        return this.columnHeaders;
    }

    public Object[][] getRowHeaders() {
        return this.rowHeaders;
    }
}

