/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.email;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.email.IEmailConfiguration;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.email.EmailConfiguration;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

@XmlRootElement
public class EmailConfigurationXml
extends EmailConfiguration {
    private static final long serialVersionUID = -3938443547757985845L;
    private static final String ROOT_ELEMENT = "email-smtp";
    private static final String PASSWORD_XPATH = "email-smtp/mail.password";
    private static final String AUTHENTICATE_XPATH = "email-smtp/properties/mail.smtp.auth";
    private static final String DEBUG_XPATH = "email-smtp/properties/mail.debug";
    private static final String DEFAULT_FROM_XPATH = "email-smtp/mail.from.default";
    private static final String FROM_NAME_XPATH = "email-smtp/mail.from.name";
    private static final String SMTP_HOST_XPATH = "email-smtp/properties/mail.smtp.host";
    private static final String SMTP_PORT_XPATH = "email-smtp/properties/mail.smtp.port";
    private static final String SMTP_PROTOCOL_XPATH = "email-smtp/properties/mail.transport.protocol";
    private static final String SMTP_QUIT_WAIT_XPATH = "email-smtp/properties/mail.smtp.quitwait";
    private static final String USER_ID_XPATH = "email-smtp/mail.userid";
    private static final String USE_SSL_XPATH = "email-smtp/properties/mail.smtp.ssl";
    private static final String USE_START_TLS_XPATH = "email-smtp/properties/mail.smtp.starttls.enable";
    private static final Integer MIN_PORT_NUMBER = 0;
    private static final Integer MAX_PORT_NUMBER = 65535;
    private static final Log logger = LogFactory.getLog(EmailConfigurationXml.class);
    private static final Messages messages = Messages.getInstance();
    private static final String DEFAULT_EMAIL_CONFIG_PATH = "system" + File.separator + "smtp-email" + File.separator + "email_config.xml";

    public EmailConfigurationXml() throws Exception {
        this(new File(PentahoSystem.getApplicationContext().getSolutionPath(DEFAULT_EMAIL_CONFIG_PATH)));
    }

    public EmailConfigurationXml(File pentahoXmlFile) throws IOException, DocumentException {
        if (null == pentahoXmlFile) {
            throw new IllegalArgumentException();
        }
        this.loadFromConfigurationDocument(XmlDom4JHelper.getDocFromFile((File)pentahoXmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public EmailConfigurationXml(String xml) throws DocumentException, XmlParseException {
        if (null == xml) {
            throw new IllegalArgumentException();
        }
        this.loadFromConfigurationDocument(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    protected EmailConfigurationXml(Document doc) throws DocumentException {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        this.loadFromConfigurationDocument(doc);
    }

    private void loadFromConfigurationDocument(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException(messages.getErrorString("EmailConfigurationXml.ERROR_0002_INVALID_ROOT_ELEMENT"));
        }
        this.setSmtpHost(EmailConfigurationXml.getStringValue(doc, SMTP_HOST_XPATH));
        this.setSmtpPort(EmailConfigurationXml.getIntegerPortValue(doc, SMTP_PORT_XPATH));
        this.setSmtpProtocol(EmailConfigurationXml.getStringValue(doc, SMTP_PROTOCOL_XPATH));
        this.setUseStartTls(EmailConfigurationXml.getBooleanValue(doc, USE_START_TLS_XPATH));
        this.setAuthenticate(EmailConfigurationXml.getBooleanValue(doc, AUTHENTICATE_XPATH));
        this.setUseSsl(EmailConfigurationXml.getBooleanValue(doc, USE_SSL_XPATH));
        this.setDebug(EmailConfigurationXml.getBooleanValue(doc, DEBUG_XPATH));
        this.setSmtpQuitWait(EmailConfigurationXml.getBooleanValue(doc, SMTP_QUIT_WAIT_XPATH));
        this.setDefaultFrom(EmailConfigurationXml.getStringValue(doc, DEFAULT_FROM_XPATH));
        this.setFromName(EmailConfigurationXml.getStringValue(doc, FROM_NAME_XPATH));
        this.setUserId(EmailConfigurationXml.getStringValue(doc, USER_ID_XPATH));
        this.setPassword(EmailConfigurationXml.getStringValue(doc, PASSWORD_XPATH));
    }

    private static String getStringValue(Document doc, String xpath) {
        try {
            Element element = (Element)doc.selectSingleNode(xpath);
            return element != null ? element.getText() : null;
        }
        catch (Exception e) {
            logger.error((Object)messages.getErrorString("EmailConfigurationXml.ERROR_0001_ERROR_PARSING_DATA", new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    private static Integer getIntegerPortValue(Document doc, String xpath) {
        try {
            Element element = (Element)doc.selectSingleNode(xpath);
            Integer value = Integer.MIN_VALUE;
            if (element != null && !StringUtils.isEmpty((String)element.getText())) {
                value = Integer.parseInt(element.getText());
            }
            if (value >= MIN_PORT_NUMBER && value <= MAX_PORT_NUMBER) {
                return value;
            }
        }
        catch (Exception e) {
            logger.error((Object)messages.getErrorString("EmailConfigurationXml.ERROR_0001_ERROR_PARSING_DATA", new Object[]{e.getLocalizedMessage()}));
        }
        return Integer.MIN_VALUE;
    }

    private static boolean getBooleanValue(Document doc, String xpath) {
        try {
            Element element = (Element)doc.selectSingleNode(xpath);
            return element != null && Boolean.parseBoolean(element.getText());
        }
        catch (Exception e) {
            logger.error((Object)messages.getErrorString("EmailConfigurationXml.ERROR_0001_ERROR_PARSING_DATA", new Object[]{e.getLocalizedMessage()}));
            return false;
        }
    }

    private static void setValue(Document doc, String xPath, String value) {
        Element element = (Element)doc.selectSingleNode(xPath);
        if (null == element) {
            element = DocumentHelper.makeElement((Branch)doc, (String)xPath);
        }
        element.setText(value);
    }

    public Document getDocument() {
        return EmailConfigurationXml.getDocument(this);
    }

    public static Document getDocument(IEmailConfiguration emailConfiguration) {
        Document document = DocumentHelper.createDocument();
        document.addElement(ROOT_ELEMENT);
        EmailConfigurationXml.setValue(document, SMTP_HOST_XPATH, ObjectUtils.toString((Object)emailConfiguration.getSmtpHost()));
        EmailConfigurationXml.setValue(document, SMTP_PORT_XPATH, ObjectUtils.toString((Object)emailConfiguration.getSmtpPort()));
        EmailConfigurationXml.setValue(document, SMTP_PROTOCOL_XPATH, ObjectUtils.toString((Object)emailConfiguration.getSmtpProtocol()));
        EmailConfigurationXml.setValue(document, USE_START_TLS_XPATH, ObjectUtils.toString((Object)emailConfiguration.isUseStartTls(), (String)Boolean.FALSE.toString()));
        EmailConfigurationXml.setValue(document, AUTHENTICATE_XPATH, ObjectUtils.toString((Object)emailConfiguration.isAuthenticate(), (String)Boolean.FALSE.toString()));
        EmailConfigurationXml.setValue(document, USE_SSL_XPATH, ObjectUtils.toString((Object)emailConfiguration.isUseSsl(), (String)Boolean.FALSE.toString()));
        EmailConfigurationXml.setValue(document, DEBUG_XPATH, ObjectUtils.toString((Object)emailConfiguration.isDebug(), (String)Boolean.FALSE.toString()));
        EmailConfigurationXml.setValue(document, SMTP_QUIT_WAIT_XPATH, ObjectUtils.toString((Object)emailConfiguration.isSmtpQuitWait(), (String)Boolean.FALSE.toString()));
        EmailConfigurationXml.setValue(document, DEFAULT_FROM_XPATH, ObjectUtils.toString((Object)emailConfiguration.getDefaultFrom()));
        EmailConfigurationXml.setValue(document, FROM_NAME_XPATH, ObjectUtils.toString((Object)emailConfiguration.getFromName()));
        EmailConfigurationXml.setValue(document, USER_ID_XPATH, ObjectUtils.toString((Object)emailConfiguration.getUserId()));
        EmailConfigurationXml.setValue(document, PASSWORD_XPATH, ObjectUtils.toString((Object)emailConfiguration.getPassword()));
        return document;
    }
}

