/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.olap.Util;
import mondrian.util.Pair;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.plugin.action.mondrian.catalog.IAclAwareMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.mimeType.MimeType;
import org.xml.sax.SAXException;

public class MondrianImportHandler
implements IPlatformImportHandler {
    private static final String PARAMETERS = "parameters";
    private static final String ENABLE_XMLA = "EnableXmla";
    private static final String DOMAIN_ID = "domain-id";
    private static final String DATA_SOURCE = "DataSource";
    private static final String PROVIDER = "Provider";
    private List<MimeType> mimeTypes;
    IMondrianCatalogService mondrianRepositoryImporter;

    public MondrianImportHandler(List<MimeType> mimeTypes, IMondrianCatalogService mondrianImporter) {
        if (mondrianImporter == null) {
            throw new IllegalArgumentException();
        }
        this.mimeTypes = mimeTypes;
        this.mondrianRepositoryImporter = mondrianImporter;
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException, DomainIdNullException, DomainAlreadyExistsException, DomainStorageException, IOException {
        boolean overwriteInRepossitory = bundle.overwriteInRepository();
        boolean xmla = !"false".equalsIgnoreCase(this.findParameterPropertyValue(bundle, ENABLE_XMLA));
        String domainId = (String)bundle.getProperty(DOMAIN_ID);
        if (domainId == null) {
            throw new PlatformImportException("Bundle missing required domain-id property");
        }
        try {
            InputStream is = bundle.getInputStream();
            MondrianCatalog catalog = this.createCatalogObject(domainId, xmla, bundle);
            IPentahoSession session = PentahoSessionHolder.getSession();
            if (this.mondrianRepositoryImporter instanceof IAclAwareMondrianCatalogService) {
                RepositoryFileAcl acl = bundle.isApplyAclSettings() ? bundle.getAcl() : null;
                IAclAwareMondrianCatalogService aware = (IAclAwareMondrianCatalogService)this.mondrianRepositoryImporter;
                aware.addCatalog(is, catalog, overwriteInRepossitory, acl, session);
            } else {
                this.mondrianRepositoryImporter.addCatalog(is, catalog, overwriteInRepossitory, session);
            }
        }
        catch (MondrianCatalogServiceException mse) {
            int statusCode = this.convertExceptionToStatus(mse);
            throw new PlatformImportException(mse.getMessage(), statusCode);
        }
        catch (Exception e) {
            throw new PlatformImportException(e.getMessage(), 2);
        }
    }

    private String findParameterPropertyValue(IPlatformImportBundle bundle, String key) {
        String value = (String)bundle.getProperty(key);
        if (value == null) {
            Util.PropertyList propertyList = Util.parseConnectString((String)((String)bundle.getProperty(PARAMETERS)));
            value = propertyList.get(key);
        }
        return value;
    }

    private Map<String, String> findParameters(IPlatformImportBundle bundle) {
        Util.PropertyList propertyList = Util.parseConnectString((String)((String)bundle.getProperty(PARAMETERS)));
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Pair prop : propertyList) {
            parameters.put((String)prop.left, (String)prop.right);
        }
        return parameters;
    }

    private int convertExceptionToStatus(MondrianCatalogServiceException mse) {
        int statusCode = 1;
        if (mse.getReason().equals((Object)MondrianCatalogServiceException.Reason.GENERAL)) {
            statusCode = 2;
        } else if (mse.getReason().equals((Object)MondrianCatalogServiceException.Reason.ACCESS_DENIED)) {
            statusCode = 1;
        } else if (mse.getReason().equals((Object)MondrianCatalogServiceException.Reason.ALREADY_EXISTS)) {
            statusCode = 8;
        } else if (mse.getReason().equals((Object)MondrianCatalogServiceException.Reason.XMLA_SCHEMA_NAME_EXISTS)) {
            statusCode = 7;
        }
        return statusCode;
    }

    protected MondrianCatalog createCatalogObject(String catName, boolean xmlaEnabled, IPlatformImportBundle bundle) throws ParserConfigurationException, SAXException, IOException, PlatformImportException {
        Map<String, String> parameters = this.findParameters(bundle);
        String dsName = this.findParameterPropertyValue(bundle, DATA_SOURCE);
        String provider = parameters.containsKey(PROVIDER) ? this.findParameterPropertyValue(bundle, PROVIDER) : "mondrian";
        StringBuilder sb = new StringBuilder();
        if (dsName != null) {
            sb.append("DataSource=" + dsName + ";");
        }
        if (!parameters.containsKey(ENABLE_XMLA)) {
            sb.append("EnableXmla=" + xmlaEnabled + ";");
        }
        sb.append("Provider=" + provider);
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (parameter.getKey().equals(DATA_SOURCE) || parameter.getKey().equals(PROVIDER)) continue;
            sb.append(";");
            sb.append(parameter.getKey());
            sb.append("=\"");
            sb.append(parameter.getValue());
            sb.append("\"");
        }
        MondrianCatalog catalog = new MondrianCatalog(catName, sb.toString(), provider + ":" + "/" + catName, null, null);
        return catalog;
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return this.mimeTypes;
    }
}

