/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.LocaleFilesProcessor;
import org.pentaho.platform.plugin.services.importer.PentahoPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.SolutionFileImportHelper;
import org.pentaho.platform.plugin.services.importer.mimeType.MimeType;
import org.pentaho.platform.plugin.services.importexport.ExportFileNameEncoder;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifest;
import org.pentaho.platform.plugin.services.importexport.exportManifest.Parameters;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetadata;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMondrian;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.pentaho.platform.web.http.api.resources.SchedulerResource;

public class SolutionImportHandler
implements IPlatformImportHandler {
    private static final Log log = LogFactory.getLog(SolutionImportHandler.class);
    private static final String sep = ";";
    private Map<String, RepositoryFileImportBundle.Builder> cachedImports;
    private SolutionFileImportHelper solutionHelper;
    private List<MimeType> mimeTypes;

    public SolutionImportHandler(List<MimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
        this.solutionHelper = new SolutionFileImportHelper();
    }

    public ImportSession getImportSession() {
        return ImportSession.getSession();
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException, DomainIdNullException, DomainAlreadyExistsException, DomainStorageException, IOException {
        RepositoryFileImportBundle.Builder bundleBuilder;
        RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
        ZipInputStream zipImportStream = new ZipInputStream(bundle.getInputStream());
        SolutionRepositoryImportSource importSource = new SolutionRepositoryImportSource(zipImportStream);
        LocaleFilesProcessor localeFilesProcessor = new LocaleFilesProcessor();
        IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
        this.cachedImports = new HashMap<String, RepositoryFileImportBundle.Builder>();
        ExportManifest manifest = this.getImportSession().getManifest();
        String manifestVersion = null;
        if (manifest != null) {
            manifestVersion = manifest.getManifestInformation().getManifestVersion();
        }
        if (manifest != null) {
            List<ExportManifestMetadata> metadataList = manifest.getMetadataList();
            for (ExportManifestMetadata exportManifestMetadata : metadataList) {
                String domainId = exportManifestMetadata.getDomainId();
                boolean overWriteInRepository = true;
                bundleBuilder = new RepositoryFileImportBundle.Builder().charSet("UTF-8").hidden(false).overwriteFile(overWriteInRepository).mime("text/xmi+xml").withParam("domain-id", domainId);
                this.cachedImports.put(exportManifestMetadata.getFile(), bundleBuilder);
            }
            List<ExportManifestMondrian> mondrianList = manifest.getMondrianList();
            for (ExportManifestMondrian exportManifestMondrian : mondrianList) {
                String catName = exportManifestMondrian.getCatalogName();
                Parameters parametersMap = exportManifestMondrian.getParameters();
                StringBuilder parametersStr = new StringBuilder();
                for (String s : parametersMap.keySet()) {
                    parametersStr.append(s).append("=").append((String)parametersMap.get(s)).append(sep);
                }
                RepositoryFileImportBundle.Builder bundleBuilder2 = new RepositoryFileImportBundle.Builder().charSet("UTF_8").hidden(false).name(catName).overwriteFile(true).mime("application/vnd.pentaho.mondrian+xml").withParam("parameters", parametersStr.toString()).withParam("domain-id", catName);
                String xmlaEnabled = "" + exportManifestMondrian.isXmlaEnabled();
                bundleBuilder2.withParam("EnableXmla", xmlaEnabled);
                this.cachedImports.put(exportManifestMondrian.getFile(), bundleBuilder2);
            }
        }
        for (ImportSource.IRepositoryFileBundle file : importSource.getFiles()) {
            String repositoryFilePath;
            String fileName = file.getFile().getName();
            String actualFilePath = file.getPath();
            if (manifestVersion != null) {
                fileName = ExportFileNameEncoder.decodeZipFileName(fileName);
                actualFilePath = ExportFileNameEncoder.decodeZipFileName(actualFilePath);
            }
            if (this.cachedImports.containsKey(repositoryFilePath = RepositoryFilenameUtils.concat((String)PentahoPlatformImporter.computeBundlePath(actualFilePath), (String)fileName))) {
                byte[] bytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                RepositoryFileImportBundle.Builder builder = this.cachedImports.get(repositoryFilePath);
                builder.input(new ByteArrayInputStream(bytes));
                importer.importFile(this.build(builder));
                continue;
            }
            bundleBuilder = new RepositoryFileImportBundle.Builder();
            ByteArrayInputStream bundleInputStream = null;
            String decodedFilePath = file.getPath();
            RepositoryFile decodedFile = file.getFile();
            if (manifestVersion != null) {
                decodedFile = new RepositoryFile.Builder(decodedFile).path(decodedFilePath).name(fileName).title(fileName).build();
                decodedFilePath = ExportFileNameEncoder.decodeZipFileName(file.getPath());
            }
            if (file.getFile().isFolder()) {
                bundleBuilder.mime("text/directory");
                bundleBuilder.file(decodedFile);
                fileName = repositoryFilePath;
                repositoryFilePath = importBundle.getPath();
            } else {
                byte[] bytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                bundleInputStream = new ByteArrayInputStream(bytes);
                if (localeFilesProcessor.isLocaleFile(file, importBundle.getPath(), bytes)) {
                    log.trace((Object)("Skipping [" + repositoryFilePath + "], it is a locale property file"));
                    continue;
                }
                bundleBuilder.input(bundleInputStream);
                bundleBuilder.mime(this.solutionHelper.getMime(fileName));
                String filePath = decodedFilePath.equals("/") || decodedFilePath.equals("\\") ? "" : decodedFilePath;
                repositoryFilePath = RepositoryFilenameUtils.concat((String)importBundle.getPath(), (String)filePath);
            }
            bundleBuilder.name(fileName);
            bundleBuilder.path(repositoryFilePath);
            String sourcePath = decodedFilePath.startsWith("/") ? RepositoryFilenameUtils.concat((String)decodedFilePath.substring(1), (String)fileName) : (file.getFile().isFolder() ? fileName : RepositoryFilenameUtils.concat((String)decodedFilePath, (String)fileName));
            if (manifest != null && manifest.getExportManifestEntity(sourcePath) == null && file.getFile().isFolder()) continue;
            this.getImportSession().setCurrentManifestKey(sourcePath);
            bundleBuilder.charSet(bundle.getCharset());
            bundleBuilder.overwriteFile(bundle.overwriteInRepository());
            bundleBuilder.hidden(this.isFileHidden(bundle, sourcePath));
            bundleBuilder.applyAclSettings(bundle.isApplyAclSettings());
            bundleBuilder.retainOwnership(bundle.isRetainOwnership());
            bundleBuilder.overwriteAclSettings(bundle.isOverwriteAclSettings());
            bundleBuilder.acl(this.getImportSession().processAclForFile(sourcePath));
            IPlatformImportBundle platformImportBundle = this.build(bundleBuilder);
            importer.importFile(platformImportBundle);
            if (bundleInputStream == null) continue;
            ((InputStream)bundleInputStream).close();
            bundleInputStream = null;
        }
        if (manifest != null) {
            List<DatabaseConnection> datasourceList;
            List<JobScheduleRequest> scheduleList = manifest.getScheduleList();
            if (scheduleList != null) {
                SchedulerResource schedulerResource = new SchedulerResource();
                for (JobScheduleRequest jobScheduleRequest : scheduleList) {
                    try {
                        Response response = this.createSchedulerJob(schedulerResource, jobScheduleRequest);
                        if (response.getStatus() != Response.Status.OK.getStatusCode() || response.getEntity() == null) continue;
                        ImportSession.getSession().addImportedScheduleJobId(response.getEntity().toString());
                    }
                    catch (Exception e) {
                        throw new PlatformImportException(Messages.getInstance().getString("SolutionImportHandler.ERROR_0001_ERROR_CREATING_SCHEDULE", new Object[]{e.getMessage()}));
                    }
                }
            }
            if ((datasourceList = manifest.getDatasourceList()) != null) {
                IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class);
                for (DatabaseConnection databaseConnection : datasourceList) {
                    try {
                        IDatabaseConnection existingDBConnection = datasourceMgmtSvc.getDatasourceByName(databaseConnection.getName());
                        if (existingDBConnection != null && existingDBConnection.getName() != null) {
                            databaseConnection.setId(existingDBConnection.getId());
                            datasourceMgmtSvc.updateDatasourceByName(databaseConnection.getName(), (IDatabaseConnection)databaseConnection);
                            continue;
                        }
                        datasourceMgmtSvc.createDatasource((IDatabaseConnection)databaseConnection);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        localeFilesProcessor.processLocaleFiles(importer);
    }

    private boolean isFileHidden(IPlatformImportBundle bundle, String filePath) {
        Boolean result = this.getImportSession().isFileHidden(filePath);
        return result != null ? result.booleanValue() : this.solutionHelper.isInHiddenList(filePath);
    }

    private boolean isSystemPath(String bundlePath) {
        String[] split = StringUtils.split((String)bundlePath, (String)"/");
        return this.isSystemDir(split, 0) || this.isSystemDir(split, 1);
    }

    private boolean isSystemDir(String[] split, int index) {
        return split != null && index < split.length && (StringUtils.equals((String)split[index], (String)"system") || StringUtils.equals((String)split[index], (String)"admin"));
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    public IPlatformImportBundle build(RepositoryFileImportBundle.Builder builder) {
        return builder != null ? builder.build() : null;
    }

    public Response createSchedulerJob(SchedulerResource scheduler, JobScheduleRequest jobRequest) throws IOException {
        return scheduler != null ? scheduler.createJob(jobRequest) : null;
    }

    class SolutionRepositoryImportSource {
        private ZipInputStream zipInputStream;
        private List<ImportSource.IRepositoryFileBundle> files;

        public SolutionRepositoryImportSource(ZipInputStream zipInputStream) {
            this.zipInputStream = zipInputStream;
            this.files = new ArrayList<ImportSource.IRepositoryFileBundle>();
            this.initialize();
        }

        protected void initialize() {
            try {
                ZipEntry entry = this.zipInputStream.getNextEntry();
                while (entry != null) {
                    String entryName = RepositoryFilenameUtils.separatorsToRepository((String)entry.getName());
                    File tempFile = null;
                    boolean isDir = entry.isDirectory();
                    if (!isDir) {
                        if (!SolutionImportHandler.this.solutionHelper.isInApprovedExtensionList(entryName)) {
                            this.zipInputStream.closeEntry();
                            entry = this.zipInputStream.getNextEntry();
                            continue;
                        }
                        tempFile = File.createTempFile("zip", null);
                        tempFile.deleteOnExit();
                        FileOutputStream fos = new FileOutputStream(tempFile);
                        IOUtils.copy((InputStream)this.zipInputStream, (OutputStream)fos);
                        fos.close();
                    }
                    File file = new File(entryName);
                    RepositoryFile repoFile = new RepositoryFile.Builder(file.getName()).folder(isDir).hidden(false).build();
                    String parentDir = new File(entryName).getParent() == null ? "/" : new File(entryName).getParent() + "/";
                    RepositoryFileBundle repoFileBundle = new RepositoryFileBundle(repoFile, null, parentDir, tempFile, "UTF-8", null);
                    if (file.getName().equals("exportManifest.xml")) {
                        this.initializeAclManifest(repoFileBundle);
                    } else {
                        this.files.add(repoFileBundle);
                    }
                    this.zipInputStream.closeEntry();
                    entry = this.zipInputStream.getNextEntry();
                }
                this.zipInputStream.close();
            }
            catch (IOException exception) {
                String errorMessage = Messages.getInstance().getErrorString("", new Object[]{exception.getLocalizedMessage()});
                log.trace((Object)errorMessage);
            }
        }

        private void initializeAclManifest(ImportSource.IRepositoryFileBundle file) {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                SolutionImportHandler.this.getImportSession().setManifest(ExportManifest.fromXml(in));
            }
            catch (Exception e) {
                log.trace((Object)e);
            }
        }

        public List<ImportSource.IRepositoryFileBundle> getFiles() {
            return this.files;
        }
    }
}

