/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.pentaho.platform.plugin.services.importexport.IRepositoryImportLogger;
import org.pentaho.platform.plugin.services.importexport.Log4JRepositoryImportLog;

public class Log4JRepositoryImportLogger
implements IRepositoryImportLogger {
    private ThreadLocal<Log4JRepositoryImportLog> repositoryImportLog = new ThreadLocal();

    @Override
    public void startJob(OutputStream outputStream, String importRootPath, Level logLevel) {
        this.repositoryImportLog.set(new Log4JRepositoryImportLog(outputStream, importRootPath, logLevel));
        this.getLog4JRepositoryImportLog().setCurrentFilePath(this.getLog4JRepositoryImportLog().getImportRootPath());
        this.getLogger().info((Object)"Start Import Job");
    }

    @Override
    public void endJob() {
        this.getLog4JRepositoryImportLog().setCurrentFilePath(this.getLog4JRepositoryImportLog().getImportRootPath());
        this.getLogger().info((Object)"End Import Job");
        this.getLog4JRepositoryImportLog().endJob();
    }

    @Override
    public void setCurrentFilePath(String currentFilePath) {
        this.getLog4JRepositoryImportLog().setCurrentFilePath(currentFilePath);
        this.getLogger().info((Object)"Start File Import");
    }

    @Override
    public void info(String s) {
        this.getLogger().info((Object)s);
    }

    @Override
    public void error(String s) {
        this.getLogger().error((Object)s);
    }

    @Override
    public void debug(String s) {
        this.getLogger().debug((Object)s);
    }

    public void warn(String s) {
        this.getLogger().debug((Object)s);
    }

    @Override
    public void error(Exception e) {
        this.getLogger().error((Object)e);
    }

    private Log4JRepositoryImportLog getLog4JRepositoryImportLog() {
        Log4JRepositoryImportLog currentLog = this.repositoryImportLog.get();
        if (currentLog == null) {
            throw new IllegalStateException("No job started for current Thread");
        }
        return currentLog;
    }

    private Logger getLogger() {
        return this.getLog4JRepositoryImportLog().getLogger();
    }

    @Override
    public boolean hasLogger() {
        return this.repositoryImportLog.get() != null;
    }

    public void debug(Object arg0) {
        this.getLogger().debug(arg0);
    }

    public void debug(Object arg0, Throwable arg1) {
        this.getLogger().debug(arg0, arg1);
    }

    public void error(Object arg0) {
        this.getLogger().error(arg0);
    }

    public void error(Object arg0, Throwable arg1) {
        this.getLogger().error(arg0, arg1);
    }

    public void fatal(Object arg0) {
        this.getLogger().fatal(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        this.getLogger().fatal(arg0, arg1);
    }

    public void info(Object arg0) {
        this.getLogger().info(arg0);
    }

    public void info(Object arg0, Throwable arg1) {
        this.getLogger().info(arg0, arg1);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return Level.ERROR.isGreaterOrEqual((Priority)this.getLogger().getLevel());
    }

    public boolean isFatalEnabled() {
        return Level.FATAL.isGreaterOrEqual((Priority)this.getLogger().getLevel());
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return Level.WARN.isGreaterOrEqual((Priority)this.getLogger().getLevel());
    }

    public void trace(Object arg0) {
        this.getLogger().trace(arg0);
    }

    public void trace(Object arg0, Throwable arg1) {
        this.getLogger().trace(arg0, arg1);
    }

    public void warn(Object arg0) {
        this.getLogger().warn(arg0);
    }

    public void warn(Object arg0, Throwable arg1) {
        this.getLogger().warn(arg0, arg1);
    }
}

