/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataAclHolder;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataDomainRepository;
import org.pentaho.platform.plugin.services.metadata.SessionAwareRowLevelSecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;

public class SecurityAwarePentahoMetadataDomainRepository
extends PentahoMetadataDomainRepository {
    private static final Log logger = LogFactory.getLog(SecurityAwarePentahoMetadataDomainRepository.class);
    public static final int[] ACCESS_TYPE_MAP = new int[]{0, 1, 2, 3, 4, 4};

    public SecurityAwarePentahoMetadataDomainRepository(IUnifiedRepository repository) {
        super(repository);
    }

    public IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    @Override
    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        RowLevelSecurity rls = model.getRowLevelSecurity();
        if (rls == null || rls.getType() == RowLevelSecurity.Type.NONE) {
            return null;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            logger.info((Object)Messages.getInstance().getString("SecurityAwareCwmSchemaFactory.INFO_AUTH_NULL_CONTINUE"));
            return "FALSE()";
        }
        String username = auth.getName();
        HashSet<String> roles = null;
        roles = new HashSet<String>();
        for (GrantedAuthority role : auth.getAuthorities()) {
            roles.add(role.getAuthority());
        }
        SessionAwareRowLevelSecurityHelper helper = new SessionAwareRowLevelSecurityHelper();
        return helper.getOpenFormulaSecurityConstraint(rls, username, new ArrayList(roles));
    }

    @Override
    public boolean hasAccess(int accessType, IConcept aclHolder) {
        boolean result = true;
        if (aclHolder != null) {
            PentahoMetadataAclHolder newHolder = new PentahoMetadataAclHolder(aclHolder);
            int mappedActionOperation = ACCESS_TYPE_MAP[accessType];
            result = SecurityHelper.getInstance().hasAccess((IAclHolder)newHolder, mappedActionOperation, this.getSession());
        } else if (accessType == 5) {
            result = SecurityHelper.getInstance().isPentahoAdministrator(this.getSession());
        }
        return result;
    }
}

