/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.services.messages.Messages;

public class PluginClassLoader
extends URLClassLoader {
    private static Log log = LogFactory.getLog(PluginClassLoader.class);
    private File pluginDir;
    private boolean overrideLoad = false;

    public PluginClassLoader(File pluginDir, ClassLoader parent) {
        super(PluginClassLoader.getPluginUrls(pluginDir), parent);
        this.pluginDir = pluginDir;
        if (log.isDebugEnabled()) {
            log.debug((Object)"URLs for this classloader:");
            for (URL url : this.getURLs()) {
                log.debug((Object)url);
            }
        }
    }

    public PluginClassLoader(File pluginDir, Object o) {
        this(pluginDir, o.getClass().getClassLoader());
    }

    public void setOverrideLoad(boolean b) {
        this.overrideLoad = b;
        if (b) {
            log.debug((Object)("classloader " + this + " is set to override mode.  loadClass will now attempt to load " + "the class from the classpath known to this classloader before delegating to the parent classloader"));
        }
    }

    protected static URL[] getPluginUrls(File pluginDir) {
        ArrayList<URL> urls = new ArrayList<URL>();
        File libDir = new File(pluginDir, "lib");
        try {
            urls.add(pluginDir.toURI().toURL());
            urls.add(libDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            log.warn((Object)Messages.getInstance().getString("PluginClassLoader.WARN_FAILED_TO_ADD_PLUGIN_DIR_TO_CLASSPATH", new Object[]{pluginDir.getAbsolutePath(), libDir.getAbsolutePath()}), (Throwable)e);
        }
        PluginClassLoader.addJars(urls, libDir);
        return urls.toArray(new URL[urls.size()]);
    }

    protected static void addJars(List<URL> urls, File folder) {
        WildcardFileFilter filter;
        File[] jarFiles;
        if (folder.exists() && folder.isDirectory() && (jarFiles = folder.listFiles((FilenameFilter)(filter = new WildcardFileFilter("*.jar")))) != null && jarFiles.length > 0) {
            for (File file : jarFiles) {
                URL url = null;
                try {
                    url = file.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding jar to plugin classloader: " + url.toString()));
                    }
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)MessageFormat.format("PluginClassLoader.WARN_FAILED_TO_ADD_JAR_TO_CLASSPATH", file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    public File getPluginDir() {
        return this.pluginDir;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> t;
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loadClass(" + name + ")... "));
            }
            t = null;
            t = this.findLoadedClass(name);
            if (t != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("{0} loaded by {1}", name, t.getClassLoader()));
                }
                return t;
            }
            if (this.overrideLoad) {
                try {
                    t = this.findClass(name);
                    if (t != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)MessageFormat.format("{0} loaded by {1}", name, this));
                        }
                        if (resolve) {
                            this.resolveClass(t);
                        }
                        return t;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!log.isTraceEnabled()) break block10;
                    log.trace((Object)MessageFormat.format("class {0} not found in loader {1}. Trying parent loader", name, this));
                }
            }
        }
        t = super.loadClass(name, resolve);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("{0} loaded by {1}", name, t.getClassLoader()));
        }
        return t;
    }

    public String toString() {
        return super.toString() + (this.pluginDir != null ? " at " + this.pluginDir.getAbsolutePath() : "");
    }
}

