/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr.perspective;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.perspective.IPluginPerspectiveManager;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class DefaultPluginPerspectiveManager
implements IPluginPerspectiveManager {
    private static final Log logger = LogFactory.getLog(DefaultPluginPerspectiveManager.class);
    private ArrayList<IPluginPerspective> pluginPerspectives = new ArrayList();

    public List<IPluginPerspective> getPluginPerspectives() {
        List<Object> perspectives = this.pluginPerspectives.isEmpty() ? PentahoSystem.getAll(IPluginPerspective.class, null) : this.pluginPerspectives;
        ArrayList<IPluginPerspective> allowedPerspectives = new ArrayList<IPluginPerspective>();
        for (IPluginPerspective iPluginPerspective : perspectives) {
            ArrayList actions = iPluginPerspective.getRequiredSecurityActions();
            IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
            boolean allowed = true;
            if (policy != null && actions != null && !actions.isEmpty()) {
                String actionName;
                Iterator i$ = actions.iterator();
                while (i$.hasNext() && (allowed = policy.isAllowed(actionName = (String)i$.next()))) {
                }
            }
            if (!allowed) continue;
            allowedPerspectives.add(iPluginPerspective);
        }
        return allowedPerspectives;
    }

    public void addPluginPerspective(IPluginPerspective pluginPerspective) {
        this.pluginPerspectives.add(pluginPerspective);
    }

    public void removePluginPerspective(IPluginPerspective pluginPerspective) {
        this.pluginPerspectives.remove(pluginPerspective);
    }

    public void clearPluginPerspectives() {
        this.pluginPerspectives.clear();
    }
}

