/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr.servicemgr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.IServiceTypeManager;

public abstract class AbstractServiceTypeManager
implements IServiceTypeManager {
    protected Collection<IServiceConfig> registeredServiceConfigs = new ArrayList<IServiceConfig>();
    protected Map<String, Class<?>> serviceClassMap = new HashMap();
    protected Map<String, Object> serviceInstanceMap = new HashMap<String, Object>();

    @Override
    public void registerService(IServiceConfig wsConfig) {
        this.serviceClassMap.put(wsConfig.getId(), wsConfig.getServiceClass());
        this.registeredServiceConfigs.add(wsConfig);
    }

    @Override
    public IServiceConfig getServiceConfig(String serviceId) {
        for (IServiceConfig config : this.registeredServiceConfigs) {
            if (!config.getId().equals(serviceId)) continue;
            return config;
        }
        return null;
    }

    @Override
    public Object getServiceBean(String serviceId) throws ServiceException {
        Object serviceInstance = this.serviceInstanceMap.get(serviceId);
        if (serviceInstance == null) {
            try {
                serviceInstance = this.serviceClassMap.get(serviceId).newInstance();
                this.serviceInstanceMap.put(serviceId, serviceInstance);
            }
            catch (InstantiationException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return serviceInstance;
    }
}

