/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap.transform;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SearchResultToAttrValueList
implements Transformer,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SearchResultToAttrValueList.class);
    private String attributeName;
    private String tokenName;

    public SearchResultToAttrValueList(String attributeName) {
        this(attributeName, null);
    }

    public SearchResultToAttrValueList(String attributeName, String tokenName) {
        this.attributeName = attributeName;
        this.tokenName = tokenName;
    }

    protected String extract(String src, String inTokenName) {
        String[] tokens;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("SearchResultToAttrValueList.DEBUG_LOOKING_FOR_SUBSTRING", new Object[]{inTokenName, src}));
        }
        for (String rdnString : tokens = src.split(",")) {
            String[] rdnTokens = rdnString.split("=");
            if (!rdnTokens[0].trim().equals(inTokenName)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("SearchResultToAttrValueList.DEBUG_EXTRACTED_TOKEN", new Object[]{rdnTokens[1].trim()}));
            }
            return rdnTokens[1].trim();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("SearchResultToAttrValueList.DEBUG_TOKEN_NOT_FOUND", new Object[]{inTokenName, src}));
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.attributeName);
    }

    public Object transform(Object obj) {
        HashSet transformed = obj;
        if (obj instanceof SearchResult) {
            block9: {
                transformed = new HashSet();
                Set valueSet = transformed;
                SearchResult res = (SearchResult)((Object)obj);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("SearchResultToAttrValueList.DEBUG_ATTRIBUTES_FROM_SEARCHRESULT", new Object[]{null != res.getAttributes() ? res.getAttributes().toString() : "null"}));
                }
                Attribute attr = res.getAttributes().get(this.attributeName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("SearchResultToAttrValueList.DEBUG_ATTRIBUTE_VALUE", new Object[]{this.attributeName, null != attr ? attr.toString() : "null"}));
                }
                if (attr != null) {
                    try {
                        NamingEnumeration<?> values = attr.getAll();
                        while (values.hasMore()) {
                            Object value = values.next();
                            if (StringUtils.hasLength((String)this.tokenName)) {
                                if (null != value && value instanceof String) {
                                    String tokenValue = this.extract((String)value, this.tokenName);
                                    if (null == tokenValue) continue;
                                    valueSet.add(tokenValue);
                                    continue;
                                }
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn((Object)Messages.getInstance().getString("SearchResultToAttrValueList.WARN_ATTRIBUTE_NOT_A_STRING"));
                                continue;
                            }
                            if (null == value) continue;
                            valueSet.add(value.toString());
                        }
                    }
                    catch (NamingException e) {
                        if (!logger.isErrorEnabled()) break block9;
                        logger.error((Object)Messages.getInstance().getErrorString("SearchResultToAttrValueList.ERROR_0001_NAMING_EXCEPTION"), (Throwable)e);
                    }
                }
            }
            return transformed;
        }
        return transformed;
    }
}

