/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.security.userrole.memory.UserRoleListEnhancedUserMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class InMemoryUserRoleListService
implements IUserRoleListService,
InitializingBean {
    private Comparator<String> roleComparator;
    private Comparator<String> usernameComparator;
    private List<String> allRoles;
    private UserRoleListEnhancedUserMap userRoleListEnhancedUserMap;
    private UserDetailsService userDetailsService;
    private List<String> systemRoles;

    public List<String> getAllRoles() {
        ArrayList<String> results = new ArrayList<String>(this.allRoles);
        if (null != this.roleComparator) {
            Collections.sort(results, this.roleComparator);
        }
        return results;
    }

    public List<String> getAllUsers() {
        List<String> results = Arrays.asList(this.userRoleListEnhancedUserMap.getAllUsers());
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results;
    }

    public List<String> getUsersInRole(ITenant tenant, String role) {
        List<String> results = Arrays.asList(this.userRoleListEnhancedUserMap.getUserNamesInRole(role));
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results;
    }

    public void setAllRoles(List<String> allRoles) {
        this.allRoles = new ArrayList<String>(allRoles);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.userRoleListEnhancedUserMap), (String)Messages.getInstance().getErrorString("InMemoryUserRoleListService.ERROR_0001_PROPERTY_LIST_NOT_SPECIFIED"));
        Assert.notNull(this.allRoles, (String)Messages.getInstance().getString("InMemoryUserRoleListService.ERROR_0002_ALL_AUTHORITIES_NOT_SPECIFIED"));
        Assert.notNull((Object)this.userDetailsService, (String)Messages.getInstance().getString("InMemoryUserRoleListService.ERROR_0003_USERDETAILSSERVICE_NOT_SPECIFIED"));
    }

    public List<String> getRolesForUser(ITenant tenant, String username) throws UsernameNotFoundException {
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        List<GrantedAuthority> results = Arrays.asList(user.getAuthorities());
        ArrayList<String> roles = new ArrayList<String>(results.size());
        for (GrantedAuthority role : results) {
            roles.add(role.getAuthority());
        }
        if (null != this.roleComparator) {
            Collections.sort(roles, this.roleComparator);
        }
        return roles;
    }

    public void setUserRoleListEnhancedUserMap(UserRoleListEnhancedUserMap userRoleListEnhancedUserMap) {
        this.userRoleListEnhancedUserMap = userRoleListEnhancedUserMap;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public UserRoleListEnhancedUserMap getUserRoleListEnhancedUserMap() {
        return this.userRoleListEnhancedUserMap;
    }

    public void setRoleComparator(Comparator<String> roleComparator) {
        Assert.notNull(roleComparator);
        this.roleComparator = roleComparator;
    }

    public void setUsernameComparator(Comparator<String> usernameComparator) {
        Assert.notNull(usernameComparator);
        this.usernameComparator = usernameComparator;
    }

    public List<String> getAllRoles(ITenant tenant) {
        return null;
    }

    public List<String> getAllUsers(ITenant tenant) {
        return null;
    }

    public List<String> getSystemRoles() {
        return this.systemRoles;
    }

    public void setSystemRoles(List<String> systemRoles) {
        this.systemRoles = systemRoles;
    }
}

