/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.html.themes;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.ui.IThemeResolver;
import org.pentaho.platform.api.ui.ModuleThemeInfo;
import org.pentaho.platform.api.ui.Theme;
import org.pentaho.platform.api.ui.ThemeResource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PluginThemeResolver
implements IThemeResolver {
    private static IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
    private static IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class);
    private Map<String, ModuleThemeInfo> moduleThemes = new HashMap<String, ModuleThemeInfo>();
    private Log logger = LogFactory.getLog(PluginThemeResolver.class);

    public PluginThemeResolver() {
        for (String pluginId : pluginManager.getRegisteredPlugins()) {
            this.findPluginThemes(pluginId);
        }
    }

    public Map<String, ModuleThemeInfo> getModuleThemes() {
        return this.moduleThemes;
    }

    public Map<String, Theme> getSystemThemes() {
        HashMap<String, Theme> systemThemes = new HashMap<String, Theme>();
        String defaultThemePlugin = PentahoSystem.getSystemSetting((String)"default-theme-plugin", (String)"userconsole");
        ModuleThemeInfo defaultThemePluginInfo = this.moduleThemes.get(defaultThemePlugin);
        if (defaultThemePluginInfo == null) {
            this.logger.debug((Object)("Unable to find the default theme plugin: " + defaultThemePlugin));
        } else {
            for (Theme theme : defaultThemePluginInfo.getSystemThemes()) {
                systemThemes.put(theme.getId(), theme);
            }
        }
        for (String module : this.moduleThemes.keySet()) {
            if (module.equals(defaultThemePlugin)) continue;
            for (Theme theme : this.moduleThemes.get(module).getSystemThemes()) {
                systemThemes.put(theme.getId(), theme);
            }
        }
        return systemThemes;
    }

    private void findPluginThemes(String pluginId) {
        try {
            InputStream pluginManifestStream = resLoader.getResourceAsStream(pluginManager.getClassLoader(pluginId), "themes.xml");
            if (pluginManifestStream == null) {
                return;
            }
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("themes", LocaleHelper.getDefaultLocale(), pluginManager.getClassLoader(pluginId));
            }
            catch (Exception ignored) {
                // empty catch block
            }
            SAXReader rdr = new SAXReader();
            Document pluginManifest = rdr.read(pluginManifestStream);
            String rootThemeFolder = pluginManifest.getRootElement().attributeValue("root-folder");
            if (rootThemeFolder == null) {
                return;
            }
            ModuleThemeInfo moduleThemeInfo = new ModuleThemeInfo(pluginId);
            List pluginNodes = pluginManifest.getRootElement().elements();
            for (Element themeNode : pluginNodes) {
                String themeId = themeNode.getName();
                String themeName = StringUtils.defaultIfEmpty((String)themeNode.attributeValue("display-name"), (String)themeId);
                if (themeName.startsWith("${")) {
                    themeName = resourceBundle.getString(themeName);
                }
                Theme theme = new Theme(themeId, themeName, "content/" + pluginId + "/" + rootThemeFolder + "/" + themeId + "/");
                theme.setHidden("true".equals(themeNode.attributeValue("hidden")));
                if ("true".equals(themeNode.attributeValue("system"))) {
                    moduleThemeInfo.getSystemThemes().add(theme);
                } else {
                    moduleThemeInfo.getModuleThemes().add(theme);
                }
                List resourceList = themeNode.elements();
                for (Element res : resourceList) {
                    theme.addResource(new ThemeResource(theme, res.getText()));
                }
            }
            this.moduleThemes.put(pluginId, moduleThemeInfo);
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error parsing plugin themes", (Throwable)e);
        }
    }
}

