/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.pentaho.platform.web.http.api.resources.JaxbList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JAXBContextResolver
implements ContextResolver<JAXBContext> {
    private JAXBContext context;
    private final ArrayList<Class> types = new ArrayList();
    private final ArrayList<String> arrays = new ArrayList();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public JAXBContextResolver() throws Exception {
        this.types.add(ArrayList.class);
        this.types.add(JaxbList.class);
        this.arrays.add("list");
        this.arrays.add("values");
        JSONConfiguration config = JSONConfiguration.mapped().rootUnwrapping(true).arrays(this.arrays.toArray(new String[0])).build();
        this.context = new JSONJAXBContext(config, this.types.toArray(new Class[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getContext(Class<?> objectType) {
        ArrayList<Class> arrayList = this.types;
        synchronized (arrayList) {
            if (this.types.contains(objectType)) {
                return this.context;
            }
        }
        Field[] fields = objectType.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().isAssignableFrom(ArrayList.class)) continue;
            String simpleName = fields[i].getName();
            simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
            this.arrays.add(simpleName);
        }
        String simpleName = objectType.getSimpleName();
        simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        this.arrays.add(simpleName);
        try {
            JSONConfiguration config = JSONConfiguration.mapped().rootUnwrapping(true).arrays(this.arrays.toArray(new String[this.arrays.size()])).build();
            ArrayList<Class> arrayList2 = this.types;
            synchronized (arrayList2) {
                this.types.add(objectType);
                this.context = new JSONJAXBContext(config, this.types.toArray(new Class[this.types.size()]));
            }
            return this.context;
        }
        catch (JAXBException e) {
            this.logger.error("Error creating JAXBContext for class " + objectType, (Throwable)e);
            return null;
        }
    }
}

