/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.perspective.IPluginPerspectiveManager;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.api.resources.JaxbList;
import org.pentaho.platform.web.http.api.resources.Overlay;
import org.pentaho.platform.web.http.api.resources.PluginPerspective;
import org.pentaho.platform.web.http.api.resources.Setting;
import org.pentaho.platform.web.http.api.resources.StringListWrapper;
import org.pentaho.ui.xul.XulOverlay;

@Path(value="/plugin-manager/")
public class PluginManagerResource {
    private static final String NEW_TOOLBAR_BUTTON_SETTING = "new-toolbar-button";

    @GET
    @Path(value="/overlays")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public List<Overlay> getOverlays(@QueryParam(value="id") @DefaultValue(value="") String id) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        List overlays = pluginManager.getOverlays();
        ArrayList<Overlay> result = new ArrayList<Overlay>();
        for (XulOverlay overlay : overlays) {
            if (!id.isEmpty() && !overlay.getId().equals(id)) continue;
            Overlay tempOverlay = new Overlay(overlay.getId(), overlay.getOverlayUri(), overlay.getSource(), overlay.getResourceBundleUri(), overlay.getPriority());
            result.add(tempOverlay);
        }
        return result;
    }

    @GET
    @Path(value="/perspectives")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public ArrayList<PluginPerspective> getPluginPerpectives() {
        IPluginPerspectiveManager manager = (IPluginPerspectiveManager)PentahoSystem.get(IPluginPerspectiveManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        ArrayList<PluginPerspective> perspectives = new ArrayList<PluginPerspective>();
        for (IPluginPerspective perspective : manager.getPluginPerspectives()) {
            PluginPerspective pp = new PluginPerspective();
            pp.setId(perspective.getId());
            pp.setTitle(perspective.getTitle());
            pp.setContentUrl(perspective.getContentUrl());
            pp.setLayoutPriority(perspective.getLayoutPriority());
            pp.setRequiredSecurityActions(perspective.getRequiredSecurityActions());
            pp.setResourceBundleUri(perspective.getResourceBundleUri());
            if (perspective.getOverlays() != null) {
                ArrayList<Overlay> safeOverlays = new ArrayList<Overlay>();
                for (XulOverlay orig : perspective.getOverlays()) {
                    Overlay tempOverlay = new Overlay(orig.getId(), orig.getOverlayUri(), orig.getSource(), orig.getResourceBundleUri(), orig.getPriority());
                    safeOverlays.add(tempOverlay);
                }
                pp.setOverlays(safeOverlays);
            }
            perspectives.add(pp);
        }
        return perspectives;
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getPluginIds() {
        if (this.canAdminister()) {
            IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
            return Response.ok((Object)new StringListWrapper(pluginManager.getRegisteredPlugins()), (String)"application/json").build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/{pluginId}/setting/{settingName}")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public String getPluginSetting(@PathParam(value="pluginId") String pluginId, @PathParam(value="settingName") String settingName) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        return (String)pluginManager.getPluginSetting(pluginId, settingName, null);
    }

    @GET
    @Path(value="/settings/{settingName}")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getPluginSettings(@PathParam(value="settingName") String settingName) {
        if (!NEW_TOOLBAR_BUTTON_SETTING.equals(settingName) && !this.canAdminister()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (String id : pluginManager.getRegisteredPlugins()) {
            Setting s = new Setting(id, (String)pluginManager.getPluginSetting(id, settingName, null));
            if (StringUtils.isEmpty((String)s.getValue())) continue;
            settings.add(s);
        }
        return Response.ok(new JaxbList(settings), (String)"application/json").build();
    }

    private boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

