/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.SoapHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.messages.Messages;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class XactionUtil {
    private static final Log logger = LogFactory.getLog(XactionUtil.class);

    public static void createOutputFileName(RepositoryFile file, IOutputHandler outputHandler) {
        IMimeTypeListener mimeTypeListener;
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        ActionSequenceJCRHelper actionHelper = new ActionSequenceJCRHelper(userSession);
        IActionSequence actionSequence = actionHelper.getActionSequence(file.getPath(), PentahoSystem.loggingLevel, RepositoryFilePermission.READ);
        String fileName = "content";
        if (actionSequence != null) {
            String title = actionSequence.getTitle();
            if (title != null && title.length() > 0) {
                fileName = title;
            } else {
                String sequenceName = actionSequence.getSequenceName();
                if (sequenceName != null && sequenceName.length() > 0) {
                    fileName = sequenceName;
                } else {
                    List actionDefinitionsList = actionSequence.getActionDefinitionsAndSequences();
                    int i = 0;
                    boolean done = false;
                    while (actionDefinitionsList.size() > i && !done) {
                        IActionDefinition actionDefinition = (IActionDefinition)actionDefinitionsList.get(i);
                        String componentName = actionDefinition.getComponentName();
                        if (componentName != null && componentName.length() > 0) {
                            fileName = componentName;
                            done = true;
                            continue;
                        }
                        ++i;
                    }
                }
            }
        }
        if ((mimeTypeListener = outputHandler.getMimeTypeListener()) != null) {
            mimeTypeListener.setName(fileName);
        }
    }

    public static OutputStream getOutputStream(HttpServletResponse response, boolean doMessages) throws ServletException, IOException {
        Object outputStream = null;
        outputStream = doMessages ? new ByteArrayOutputStream() : response.getOutputStream();
        return outputStream;
    }

    public static void setupOutputHandler(HttpOutputHandler outputHandler, IParameterProvider requestParameters) {
        int outputPreference = 3;
        outputHandler.setOutputPreference(outputPreference);
    }

    public static HttpOutputHandler createOutputHandler(HttpServletResponse response, OutputStream outputStream) {
        return new HttpOutputHandler(response, outputStream, true);
    }

    public static String postExecute(IRuntimeContext runtime, boolean debugMessages, boolean doWrapper, IOutputHandler outputHandler, Map<String, IParameterProvider> parameterProviders, HttpServletRequest request, HttpServletResponse response, List<?> messages) throws Exception {
        boolean printError;
        StringBuffer buffer = new StringBuffer();
        boolean hasResponse = outputHandler.isResponseExpected();
        IContentItem responseContentItem = outputHandler.getOutputContentItem("response", "content", null, null);
        boolean success = runtime != null && runtime.getStatus() == 6;
        boolean printSuccess = runtime != null && success && (!hasResponse || debugMessages);
        boolean bl = printError = runtime != null && !success && !response.isCommitted();
        if (printSuccess || printError) {
            String htmlMimeType = "text/html";
            responseContentItem.setMimeType("text/html");
            response.setContentType("text/html");
            IMessageFormatter formatter = (IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)PentahoSessionHolder.getSession());
            if (printSuccess) {
                formatter.formatSuccessMessage("text/html", runtime, buffer, debugMessages, doWrapper);
            } else {
                response.resetBuffer();
                formatter.formatFailureMessage("text/html", runtime, buffer, messages);
            }
        }
        return buffer.toString();
    }

    public static String executeHtml(RepositoryFile file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IPentahoSession userSession, IMimeTypeListener mimeTypeListener) throws Exception {
        HttpRequestParameterProvider requestParams = new HttpRequestParameterProvider(httpServletRequest);
        IRuntimeContext runtime = null;
        try {
            String str;
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
            HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(httpServletRequest);
            boolean doMessages = "true".equalsIgnoreCase(requestParams.getStringParameter("debug", "false"));
            boolean doWrapper = "true".equalsIgnoreCase(requestParams.getStringParameter("wrapper", "true"));
            HttpOutputHandler outputHandler = XactionUtil.createOutputHandler(httpServletResponse, XactionUtil.getOutputStream(httpServletResponse, doMessages));
            if (mimeTypeListener == null) {
                mimeTypeListener = new HttpMimeTypeListener(httpServletRequest, httpServletResponse, null);
            }
            outputHandler.setMimeTypeListener(mimeTypeListener);
            outputHandler.setSession(userSession);
            HashMap<String, IParameterProvider> parameterProviders = new HashMap<String, IParameterProvider>();
            parameterProviders.put("request", (IParameterProvider)requestParameters);
            parameterProviders.put("session", (IParameterProvider)sessionParameters);
            XactionUtil.createOutputFileName(file, outputHandler);
            int outputPreference = 3;
            outputHandler.setOutputPreference(outputPreference);
            boolean forcePrompt = "true".equalsIgnoreCase(requestParams.getStringParameter("prompt", "false"));
            ArrayList messages = new ArrayList();
            runtime = XactionUtil.executeInternal(file, (IParameterProvider)requestParams, httpServletRequest, outputHandler, parameterProviders, userSession, forcePrompt, messages);
            String string = str = XactionUtil.postExecute(runtime, doMessages, doWrapper, outputHandler, parameterProviders, httpServletRequest, httpServletResponse, messages);
            return string;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getString("XactionUtil.ERROR_EXECUTING_ACTION_SEQUENCE", new Object[]{file.getName()}), (Throwable)e);
            throw e;
        }
        finally {
            if (runtime != null) {
                runtime.dispose();
            }
        }
    }

    public static String executeScheduleUi(RepositoryFile file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IPentahoSession userSession, IMimeTypeListener mimeTypeListener) throws Exception {
        HttpRequestParameterProvider requestParams = new HttpRequestParameterProvider(httpServletRequest);
        IRuntimeContext runtime = null;
        try {
            String str;
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
            HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(httpServletRequest);
            boolean doMessages = "true".equalsIgnoreCase(requestParams.getStringParameter("debug", "false"));
            boolean doWrapper = "true".equalsIgnoreCase(requestParams.getStringParameter("wrapper", "true"));
            HttpOutputHandler outputHandler = XactionUtil.createOutputHandler(httpServletResponse, XactionUtil.getOutputStream(httpServletResponse, doMessages));
            if (mimeTypeListener == null) {
                mimeTypeListener = new HttpMimeTypeListener(httpServletRequest, httpServletResponse, null);
            }
            outputHandler.setMimeTypeListener(mimeTypeListener);
            outputHandler.setSession(userSession);
            HashMap<String, IParameterProvider> parameterProviders = new HashMap<String, IParameterProvider>();
            parameterProviders.put("request", (IParameterProvider)requestParameters);
            parameterProviders.put("session", (IParameterProvider)sessionParameters);
            XactionUtil.createOutputFileName(file, outputHandler);
            int outputPreference = 1;
            outputHandler.setOutputPreference(outputPreference);
            ArrayList messages = new ArrayList();
            runtime = XactionUtil.executeInternal(file, (IParameterProvider)requestParams, httpServletRequest, outputHandler, parameterProviders, userSession, true, messages);
            String string = str = XactionUtil.postExecute(runtime, doMessages, doWrapper, outputHandler, parameterProviders, httpServletRequest, httpServletResponse, messages);
            return string;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getString("XactionUtil.ERROR_EXECUTING_ACTION_SEQUENCE", new Object[]{file.getName()}), (Throwable)e);
            throw e;
        }
        finally {
            if (runtime != null) {
                runtime.dispose();
            }
        }
    }

    protected static IRuntimeContext executeInternal(RepositoryFile file, IParameterProvider requestParams, HttpServletRequest httpServletRequest, IOutputHandler outputHandler, Map<String, IParameterProvider> parameterProviders, IPentahoSession userSession, boolean forcePrompt, List messages) throws Exception {
        String processId = XactionUtil.class.getName();
        String instanceId = httpServletRequest.getParameter("instance-id");
        SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)userSession);
        ISystemSettings systemSettings = PentahoSystem.getSystemSettings();
        if (solutionEngine == null) {
            throw new ObjectFactoryException("No Solution Engine");
        }
        boolean instanceEnds = "true".equalsIgnoreCase(requestParams.getStringParameter("instanceends", "true"));
        String parameterXsl = systemSettings.getSystemSetting("default-parameter-xsl", "DefaultParameterForm.xsl");
        solutionEngine.setLoggingLevel(2);
        solutionEngine.init(userSession);
        solutionEngine.setForcePrompt(forcePrompt);
        if (parameterXsl != null) {
            solutionEngine.setParameterXsl(parameterXsl);
        }
        return solutionEngine.execute(file.getPath(), processId, false, instanceEnds, instanceId, false, parameterProviders, outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeXml(RepositoryFile file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IPentahoSession userSession) throws Exception {
        String string;
        block6: {
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
            HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(httpServletRequest);
            HashMap<String, IParameterProvider> parameterProviders = new HashMap<String, IParameterProvider>();
            parameterProviders.put("request", (IParameterProvider)requestParameters);
            parameterProviders.put("session", (IParameterProvider)sessionParameters);
            ArrayList messages = new ArrayList();
            HttpRequestParameterProvider requestParams = new HttpRequestParameterProvider(httpServletRequest);
            httpServletResponse.setContentType("text/xml");
            httpServletResponse.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            boolean forcePrompt = "true".equalsIgnoreCase(requestParams.getStringParameter("prompt", "false"));
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            SimpleOutputHandler outputHandler = new SimpleOutputHandler((OutputStream)contentStream, false);
            IRuntimeContext runtime = null;
            try {
                runtime = XactionUtil.executeInternal(file, (IParameterProvider)requestParams, httpServletRequest, (IOutputHandler)outputHandler, parameterProviders, userSession, forcePrompt, messages);
                Document responseDoc = SoapHelper.createSoapResponseDocument((IRuntimeContext)runtime, (IOutputHandler)outputHandler, (OutputStream)contentStream, messages);
                OutputFormat format = OutputFormat.createCompactFormat();
                format.setSuppressDeclaration(true);
                format.setEncoding("utf-8");
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
                writer.write(responseDoc);
                writer.flush();
                string = outputStream.toString("utf-8");
                if (runtime == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (runtime != null) {
                        runtime.dispose();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn((Object)Messages.getInstance().getString("XactionUtil.XML_OUTPUT_NOT_SUPPORTED"));
                    throw e;
                }
            }
            runtime.dispose();
        }
        return string;
    }

    public static String execute(String returnContentType, RepositoryFile file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IPentahoSession userSession, IMimeTypeListener mimeTypeListener) throws Exception {
        if (returnContentType != null && returnContentType.equals("application/xml")) {
            return XactionUtil.executeXml(file, httpServletRequest, httpServletResponse, userSession);
        }
        return XactionUtil.executeHtml(file, httpServletRequest, httpServletResponse, userSession, mimeTypeListener);
    }

    public static String doParameter(RepositoryFile file, IParameterProvider parameterProvider, IPentahoSession userSession) throws IOException {
        ActionSequenceJCRHelper helper = new ActionSequenceJCRHelper();
        IActionSequence actionSequence = helper.getActionSequence(file.getPath(), PentahoSystem.loggingLevel, RepositoryFilePermission.READ);
        Document document = DocumentHelper.createDocument();
        try {
            Element parametersElement = document.addElement("parameters");
            Map params = actionSequence.getInputDefinitionsForParameterProvider("request");
            for (Map.Entry entry : params.entrySet()) {
                String paramName = (String)entry.getKey();
                IActionParameter paramDef = (IActionParameter)entry.getValue();
                String value = paramDef.getStringValue();
                Class type = "list".equalsIgnoreCase(paramDef.getType()) ? String[].class : String.class;
                String label = paramDef.getSelectionDisplayName();
                String[] values = StringUtils.isEmpty((String)value) ? new String[]{} : new String[]{value};
                XactionUtil.createParameterElement(parametersElement, paramName, type, label, "user", "parameters", values);
            }
            XactionUtil.createParameterElement(parametersElement, "path", String.class, null, "system", "system", new String[]{file.getPath()});
            XactionUtil.createParameterElement(parametersElement, "prompt", String.class, null, "system", "system", new String[]{"yes", "no"});
            XactionUtil.createParameterElement(parametersElement, "instance-id", String.class, null, "system", "system", new String[]{parameterProvider.getStringParameter("instance-id", null)});
            OutputFormat format = OutputFormat.createCompactFormat();
            format.setSuppressDeclaration(true);
            format.setEncoding("utf-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(document);
            writer.flush();
            return outputStream.toString("utf-8");
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getInstance().getString("HttpWebService.ERROR_0003_UNEXPECTED"), (Throwable)e);
            return null;
        }
    }

    private static Element createParameterElement(Element parametersElement, String paramName, Class type, String label, String role, String group, String[] values) {
        Element parameterElement = parametersElement.addElement("parameter");
        parameterElement.addAttribute("name", paramName);
        parameterElement.addAttribute("type", type.getName());
        if (!StringUtils.isEmpty((String)label)) {
            Element labelAttr = parameterElement.addElement("attribute");
            labelAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
            labelAttr.addAttribute("name", "label");
            labelAttr.addAttribute("value", label);
        }
        Element roleAttr = parameterElement.addElement("attribute");
        roleAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        roleAttr.addAttribute("name", "role");
        roleAttr.addAttribute("value", role);
        Element paramGroupAttr = parameterElement.addElement("attribute");
        paramGroupAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        paramGroupAttr.addAttribute("name", "parameter-group");
        paramGroupAttr.addAttribute("value", group);
        Element paramGroupLabelAttr = parameterElement.addElement("attribute");
        paramGroupLabelAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        paramGroupLabelAttr.addAttribute("name", "parameter-group-label");
        paramGroupLabelAttr.addAttribute("value", XactionUtil.lookupParameterGroupLabel(group));
        if (values.length > 0) {
            Element valuesElement = parameterElement.addElement("values");
            for (String value : values) {
                Element valueAttr = valuesElement.addElement("value");
                valueAttr.addAttribute("type", String.class.getName());
                valueAttr.addAttribute("value", value);
                valueAttr.addAttribute("selected", String.valueOf(values.length == 1));
            }
        }
        return parameterElement;
    }

    private static String lookupParameterGroupLabel(String group) {
        if ("system".equals(group)) {
            return Messages.getInstance().getString("HttpWebService.PARAMETER_GROUP_SYSTEM");
        }
        return Messages.getInstance().getString("HttpWebService.PARAMETER_GROUP_USER");
    }
}

